/* c't Steckdose-im-LAN Demo Source
 * Datei: schalt.c 
 * Info: Routinen zur Ansteuerung der Relais und der Stromfuehler
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.05
*/

#include "schalt.h"
#include <avr/io.h>
#include "lib/adc.h"
#include "lib/led.h"
#include "lib/uart.h"
#include "lib/display.h"
#include "lib/tools.h"
#include <math.h>

REL RELAIS[7];

void Relais_off(unsigned char Relais){
	switch(RELAIS[Relais].PORT){ 
		case 'A': PORTA &= ~RELAIS[Relais].PIN;
			break;
		case 'B': PORTB &= ~RELAIS[Relais].PIN;
			break;
		case 'C': PORTC &= ~RELAIS[Relais].PIN;
			break;
		case 'D': PORTD &= ~RELAIS[Relais].PIN;
			break;
	}
}
			
void Relais_on(unsigned char Relais){
	switch(RELAIS[Relais].PORT){ 
		case 'A': PORTA |= RELAIS[Relais].PIN;
			break;
		case 'B': PORTB |= RELAIS[Relais].PIN;
			break;
		case 'C': PORTC |= RELAIS[Relais].PIN;
			break;
		case 'D': PORTD |= RELAIS[Relais].PIN;
			break;
	}
	//PORTD |= LED;	// LED ausschalten
}

/*Schaltet alle Relais an oder aus. Der bergabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw.
BitX==0 bedeutet aus BitX==1 bedeutet an
*/
void Relais_set(unsigned char Relais){
	unsigned char i;
	for (i=0; i<7; i++){
		if ((Relais & (1<<i))==0)
			Relais_off(i);
		else 
			Relais_on(i);
	}
}

/*Schaltet nur die maskierten Relais an oder aus, der Rest bleibt unverndert.
Der bergabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw. BitX==0 bedeutet aus BitX==1 bedeutet an
*/
void Relais_set_masked(unsigned char relais, unsigned char mask){
	unsigned char state;

	state= Relais_get();
	
	state= (state & ~mask) | (relais & mask);
	Relais_set(state);
}

/*Liefert den Zustand aller Relais Der Rckgabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw.
BitX==0 bedeutet aus BitX==1 bedeutet an
*/
char Relais_get(void){
	int Relais,State;
	State=0;
	for (Relais=0; Relais<7; Relais++){
		switch(RELAIS[Relais].PORT){ 
			case 'A': 
				if ((PORTA & RELAIS[Relais].PIN) > 0)
					State+= 1<<Relais;
				break;
			case 'B': 
				if ((PORTB & RELAIS[Relais].PIN) > 0)
					State+= 1<<Relais;
				break;
			case 'C': 
				if ((PORTC & RELAIS[Relais].PIN) > 0)
					State+= 1<<Relais;
				break;
			case 'D': 
				if ((PORTD & RELAIS[Relais].PIN) > 0)
					State+= 1<<Relais;
				break;
		}		
	}
	return State;
}

/* Initialisiere Ports fr Relais und Stromfhler */
void schalt_init(void){
	int Relais;
	
	// Array Initialisieren
	RELAIS[0].PIN = RELAIS_1_PIN;	RELAIS[0].PORT = RELAIS_1_PORT;
	RELAIS[1].PIN = RELAIS_2_PIN;	RELAIS[1].PORT = RELAIS_2_PORT;
	RELAIS[2].PIN = RELAIS_3_PIN;	RELAIS[2].PORT = RELAIS_3_PORT;
	RELAIS[3].PIN = RELAIS_4_PIN;	RELAIS[3].PORT = RELAIS_4_PORT;
	RELAIS[4].PIN = RELAIS_5_PIN;	RELAIS[4].PORT = RELAIS_5_PORT;
	RELAIS[5].PIN = RELAIS_6_PIN;	RELAIS[5].PORT = RELAIS_6_PORT;
	RELAIS[6].PIN = RELAIS_7_PIN;	RELAIS[6].PORT = RELAIS_7_PORT;

	// Alle Relais-Pins als Ausgnge und alle Relais aus
	for (Relais=0; Relais<7; Relais++){
		switch(RELAIS[Relais].PORT){ 
			case 'A': DDRA|= RELAIS[Relais].PIN;
				break;
			case 'B': DDRB|= RELAIS[Relais].PIN;
				break;
			case 'C': DDRC|=  RELAIS[Relais].PIN;
				break;
			case 'D': DDRD|=  RELAIS[Relais].PIN;
				break;
		}
		Relais_off(Relais);
	}
}
