/* c't-Netz-Schalter Demo Source
 * Datei: command.c
 * Info: Serial Command Management
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 07.10.05
*/

#include "../mcu.h"

#include "command.h"

#include "led.h"
#include "key.h"
#include "uart.h"
#include "adc.h"
#include "key.h"

#include "schalt.h"
#include "event.h"
#include "rtc.h"
#include "command.h"
#include "tools.h"
#include "display.h"

#define CMD_LENGTH 8
#define CMD_STARTCODE 0x41
#define CMD_STOPCODE 0x42

#define DEST_XPORT 0
#define DEST_COM 1
#define DEST_PASSTHROUGH 2

#define COMMAND_LEDS	0x30
#define LAUFLICHT	0x31
#define SWITCH_DEST 	0x50
#define READKEY		0x60
#define READADC		0x70
// Reads 64 ADC Values
#define READADC_64	0x43	 

#define SETTIME	0x44	 
#define SETDATE	0x45

#define GETEVENT 0x46
#define SETEVENT 0x47
#define DELETEEVENT 0x48

#define SETRELAIS	0x80
#define READRELAIS	0x81

#ifdef COMMAND_AVAILABLE
char command[CMD_LENGTH];		// Puffer fr Kommando von/an PC

// Liest ein Kommando von der seriellen Schnittstelle
char read_command(void){
	int i=1;
	
	command[0]=0x00;
	uart_timeout=0;
	// Lesen bis Startcode kommt
	while (command[0] != CMD_STARTCODE){	
		command[0] = uart_read();
		if (uart_timeout==1)
			return 0;
	}
	
	// Lesen bis Stopcode oder Puffer voll
	while ((i < CMD_LENGTH) && (command[i-1] != CMD_STOPCODE)){	
		command[i++] = uart_read();
		if (uart_timeout==1)
			return 0;
	}
	
	if ((command[0]!=CMD_STARTCODE) | (command[CMD_LENGTH-1]!=CMD_STOPCODE))
		return 0;

	return 1;
}

//Wertet das Kommando im Puffer aus
void evaluate_command(void){
	#ifdef ADC_AVAILABLE
		int adc=0;
	#endif
		// hier knnte man das Kommado verifizieren!

	switch (command[1]) {
		#ifdef LED_AVAILABLE
			case COMMAND_LEDS:	// LED Steuerung
				LED_set(command[2]);
				break;
		#endif
		case SWITCH_DEST:
			uart_dest(command[2]);
			break;
/*		case LAUFLICHT:
			lauflicht(command[2]);
			break;
*/		#ifdef KEY_AVAILABLE
			case READKEY:
				command[2]=key_read();
				break;
		#endif
		#ifdef ADC_AVAILABLE
			case READADC:
				adc=adc_read(command[2]);
				command[2]= (char) (adc && 0xFF);
				command[3]= (char) ((adc >> 8) && 0xFF);
				break;
			case READADC_64:
				adc_select_channel(command[2]);			
				adc_transmit();
				break;
		#endif
		case SETRELAIS:
			Relais_set(command[2]);
			break;
		case READRELAIS:
			command[2]= Relais_get();
			break;
		#ifdef RTC_AVAILABLE
			case SETTIME:
				rtc_set_time(command[2], command[3], command[4],command[5]);
				break;
		#endif
		#ifdef RTC_FULL_AVAILABLE		
			case SETDATE:
				rtc_set_date(command[2], command[3], (int)(command[4]*256+command[5]));
				break;
		#endif
		#ifdef EVENT_AVAILABLE
			case GETEVENT:
				event_transmit(command[2]);
				command[2]=events;
				break;
			case SETEVENT:
				event_receive(command[2]);
				command[2]=events;
				break;
			case DELETEEVENT:
				event_delete(command[2]);
				command[2]=events;
				break;
		#endif
		default:
			break;
	}
		
	uart_dest(DEST_XPORT);	// Antwort geht immer an den XPORT
	for (int i=0; i< CMD_LENGTH; i++) {
		uart_send(command[i]);
	}
	uart_dest(DEST_OLD);	// Alte serielle Konfiguration wieder herstellen.
}

#ifdef DISPLAY_AVAILABLE
	//Zeigt ein Kommando auf dem Display an
	void display_command(void){
		unsigned char i=0;
		unsigned char hex[3];
		
		display_cursor(4,1);
		display_string("0x");
		to_hex(command[i],hex);
		display_string(hex);
		display_string(" ");
		i++;
	
		while ( (i<CMD_LENGTH) && (command[i] != CMD_STOPCODE)){
			to_hex(command[i],hex);
			display_string(hex);
			i++;
		}
	
		display_string(" ");
		to_hex(command[i],hex);
		display_string(hex);
	}
#endif
#endif
