/* c't Steckdose-im-LAN Demo Source
 * Datei: schalt.h 
 * Info: Header zur Ansteuerung der Relais und der Stromfuehler
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 16.08.05
*/

typedef struct REL {
	unsigned char PIN;
	unsigned char PORT;
} REL;

#define RELAIS_1_PIN 0x80	//IO17 (PD7) Mit Stromfuehler
#define RELAIS_1_PORT 'D'

#define RELAIS_2_PIN 0x04	//IO16 (PD2) Mit Stromfuehler
#define RELAIS_2_PORT 'D'

#define RELAIS_3_PIN 0x10	//IO15 (PB4)
#define RELAIS_3_PORT 'B'

#define RELAIS_4_PIN 0x08	//IO14 (PB3)
#define RELAIS_4_PORT 'B'

#define RELAIS_5_PIN 0x80	//IO13 (PA7)
#define RELAIS_5_PORT 'A'

#define RELAIS_6_PIN 0x40	//IO12 (PA6)
#define RELAIS_6_PORT 'A'

#define RELAIS_7_PIN 0x20	//IO11 (PA5) 
#define RELAIS_7_PORT 'A'

/* Initialisiere Ports fr Relais und Stromfhler */
void schalt_init(void);

/* Schaltet ein Relais an (1-7) */
void Relais_on(unsigned char Relais);

/* Schaltet ein Relais aus (1-7) */
void Relais_off(unsigned char Relais);

/*Schaltet alle Relais an oder aus. Der bergabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw.
BitX==0 bedeutet aus BitX==1 bedeutet an
*/
void Relais_set(unsigned char Relais);

/*Schaltet nur die maskierten Relais an oder aus, der Rest bleibt unverndert.
Der bergabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw. BitX==0 bedeutet aus BitX==1 bedeutet an
*/
void Relais_set_masked(unsigned char relais, unsigned char mask);

/*Liefert den Zustand aller Relais Der Rckgabe-Parameter wird als Bitfeld interpretiert: Relais1 = Bit0, Relais2= Bit1 usw.
BitX==0 bedeutet aus BitX==1 bedeutet an
*/
char Relais_get(void);

int filter(int in);
