/// Copyright (c) 2005 Heise Zeitschriften Verlag, Oliver Lau <ola@ctmagazin.de>.
/// Alle Rechte vorbehalten.

using System;
using System.IO;
using System.Management.Automation;
using System.Runtime.InteropServices;

namespace Ct.Demo {
	/// <summary>
	/// Dieses Cmdlet implementiert eine Funktion, um so genannte
	/// Hard Links auf Dateien zu setzen.
	/// </summary>
	[System.Management.Automation.Cmdlet("link", "file")]
	public class HardLink : Cmdlet
	{
#region parameters
		private string newName;
		/// <summary>Name des Links</summary>
		[Parameter(Mandatory=true, Position=0)]
		public string NewName
		{
			get { return newName; }
			set { newName = value; }
		}

		private string existingName;
		/// <summary>Name der Datei, auf die verlinkt werden soll</summary>
		[Parameter(Mandatory=true, Position=1)]
		public string ExistingName
		{
			get { return existingName; }
			set { existingName = value; }
		}
		
#endregion

		[DllImport("kernel32.dll", SetLastError = true)]
		public static extern uint CreateHardLink(string newName, string existingName, IntPtr unused);
		
		protected override void ProcessRecord()
		{
			WriteObject("Creating hard link '" + newName + "' on '" + existingName + "'");
			CreateHardLink(newName, existingName, IntPtr.Zero);
		}
	}
}
