#ifndef RECEIVER_H
#define RECEIVER_H

#include <QApplication>
#include <QHttp>
#include <QMessageBox>

class Receiver : public QObject
{
    Q_OBJECT

public:
    Receiver( QHttp* http ) : mHttp( http ) {}

public slots:
    void slotDone( bool error )
        {
            if( error )
                QMessageBox::warning( 0, "Fehler", QString( "Beim Herunterladen ist der Fehler %1 aufgetreten." ).arg( mHttp->errorString() ) );
            QApplication::instance()->quit();
        }

private:
    QHttp* mHttp;
};




#endif /* RECEIVER_H */

