#include <QApplication>
#include <QSqlQuery>
#include <QSqlDatabase>
#include <QSqlError>
#include <QtDebug>

int main( int argc, char* argv[] )
{
    QApplication app( argc, argv );

    QSqlDatabase database = QSqlDatabase::addDatabase( "QSQLITE" );
    database.setDatabaseName( "expenses.db" );
    if( !database.open() ) {
        qDebug() << "Could not open database; driver said: " << database.lastError().driverText()
                 << ", database said: " << database.lastError().databaseText();
        return -1;
    }

    // a query that creates a table
    QSqlQuery query;
    if( !query.exec( "CREATE TABLE expenses ( "
                     "id INT PRIMARY KEY, "
                     "description VARCHAR(100), "
                     "original_amount DOUBLE, "
                     "currency VARCHAR(3), "
                     "date DATE, "
                     "exchange_rate DOUBLE, "
                     "euro_amount DOUBLE )" ) ) {
        qDebug() << "Could not create table; driver said: " << database.lastError().driverText()
                 << ", database said: " << database.lastError().databaseText();
        return -2;
    } else
        qDebug() << "Database table created";

    return 0;
}

