using System;

namespace TestParams
{
    class Program
    {
        static void TestParams1(Point p, Speed s)
        {
            p.x += 100;
            s.x += 100;
        }

        static void TestParams2(Point p, Speed s)
        {
            p = new Point(1, 1);
            s = new Speed(1, 1);
        }

        static void TestParams3(ref Point p, ref Speed s)
        {
            p = new Point(1, 1);
            s = new Speed(1, 1);
        }

        static void Main(string[] args)
        {
            Point p0 = new Point(10, 20);
            Speed g0 = new Speed(10, 20);
            TestParams1(p0, g0);
            Console.WriteLine("TestParams1");
            Console.WriteLine("p0 = " + p0.ToString());
            Console.WriteLine("g0 = " + g0.ToString());
            TestParams2(p0, g0);
            Console.WriteLine("TestParams2");
            Console.WriteLine("p0 = " + p0.ToString());
            Console.WriteLine("g0 = " + g0.ToString());
            TestParams3(ref p0, ref g0);
            Console.WriteLine("TestParams1");
            Console.WriteLine("p0 = " + p0.ToString());
            Console.WriteLine("g0 = " + g0.ToString());
            Console.ReadKey();
        }
    }

    public struct Point
    {
        public int x, y;
        public Point(int px, int py)
        {
            x = px;
            y = py;
        }
        public new string ToString()
        {
            return "(" + x.ToString() + ","
                       + y.ToString() + ")";
        }
    }

    public class Speed
    {
        public int x, y;
        public Speed(int vx, int vy)
        {
            x = vx;
            y = vy;
        }
        public new string ToString()
        {
            return "(" + x.ToString() + ","
                       + y.ToString() + ")";
        }
    }

}
