using System;

namespace StackVsHeap
{
    class Program
    {
        static void Main(string[] args)
        {
            Point p0 = new Point(10, 20);
            Point p1 = p0;
            p1.x = 100;
            Speed g0 = new Speed(10, 20);
            Speed g1 = g0;
            g1.x = 100;
            Console.WriteLine("p0 = " + p0.ToString());
            Console.WriteLine("g0 = " + g0.ToString());
            Console.ReadKey();
        }

    }

    public struct Point
    {
        public int x, y;
        public Point(int px, int py)
        {
            x = px;
            y = py;
        }
        public new string ToString()
        {
            return "(" + x.ToString() + ","
                       + y.ToString() + ")";
        }
    }

    public class Speed
    {
        public int x, y;
        public Speed(int vx, int vy)
        {
            x = vx;
            y = vy;
        }
        public new string ToString()
        {
            return "(" + x.ToString() + ","
                       + y.ToString() + ")";
        }
    }


}
