VERSION 5.00
Begin {C62A69F0-16DC-11CE-9E98-00AA00574A4F} frmAnhnge 
   Caption         =   "frmAnhnge"
   ClientHeight    =   5460
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   7815
   OleObjectBlob   =   "frmAnhnge.frx":0000
   StartUpPosition =   1  'Fenstermitte
End
Attribute VB_Name = "frmAnhnge"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' 2006, Ralf Nebelo

'API-Funktion zum ffnen/Starten der Zusammenstellungselemente
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private objMail As MailItem
Private objUniControl As Object
Private strWorkDir As String
Private str7ZipPfadname As String
Private intAnzElemente As Integer
Private curBytesGesamt As Currency
Private blnGespeichert As Boolean

'**************************************************************
'Ereignisprozeduren
'**************************************************************

Private Sub UserForm_Initialize()
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Wenn aktuelles Inspector-Fenster eine Nachricht enthlt, dann...
    If ActiveInspector.CurrentItem.Class = olMail Then
        '... Verweis auf Nachricht holen
        Set objMail = ActiveInspector.CurrentItem
        'Wenn Nachricht nicht editierbar (ungesendet) ist, dann...
        If Not objMail.Sent = False Then
            '... Dialog beenden
            End
        End If
    End If
    
    'Verweis auf UniversalTools.ocx einrichten (fr Zugriff auf Windows-Dialogfelder)
    Set objUniControl = CreateObject("UniversalTools.Control1")
    
    'Pfad des Arbeitsordners aus Registry lesen
    strWorkDir = GetSetting(OL_Anhnge.APPNAME, "Einstellungen", "txtWorkDir", OL_Anhnge.AddSlash(OL_Anhnge.HolPfadEigeneDateien) & OL_Anhnge.APPNAME)
    'Arbeitsordner anlegen (falls notwendig). Wenn das misslingt...
    If OL_Anhnge.OrdnerAnlegen(OL_Anhnge.HolPfadEigeneDateien, OL_Anhnge.APPNAME) = False Then
        '... Ordner "Eigene Dateien" als Arbeitsordner verwenden
        strWorkDir = OL_Anhnge.HolPfadEigeneDateien
    End If

    'Userform konfigurieren
    With Me
        'Fenstertiteltext festlegen
        .Caption = OL_Anhnge.APPNAME & " -  2006, Ralf Nebelo"
        'Hintergrundfarbe
        .BackColor = RGB(196, 217, 249)
        'Hintergrundfarbe von fraRahmen
        .fraRahmen.BackColor = RGB(196, 255, 255)
    End With
    
    'Listenfeld lstListe konfigurieren
    With lstListe
        '3 Spalten
        .ColumnCount = 3
        'Spaltenbreiten festlegen
        .ColumnWidths = "120;60;500"
        'Inhalt der dritten Spalte liefert den Text-Wert des Listenfelds
        .TextColumn = 3
    End With
        
    'Zuletzt aktiven Status des Kontrollkstchens aus Registry lesen
    chkZippen.Value = CBool(GetSetting(OL_Anhnge.APPNAME, "Einstellungen", "chkZippen", True))
    
    'Kombinationsfeld cmbFormt konfigurieren
    With cmbFormat
        'Archivformate eintragen
        .AddItem "7Z"
        .AddItem "ZIP"
        .AddItem "TAR"
        'Zuletzt aktiven Wert aus Registry lesen und einstellen
        .Value = GetSetting(OL_Anhnge.APPNAME, "Einstellungen", "cmbFormat", "ZIP")
    End With
    
    'Schaltflche cmdScan nur aktivieren, wenn ein Scanner angeschlossen ist
    cmdScan.Enabled = OL_Anhnge.WIA_GertVorhanden(ScannerDeviceType) > ""
    'Schaltflche cmdKamera nur aktivieren, wenn ein Video-Device (eine Webcam) angeschlossen ist
    cmdKamera.Enabled = OL_Anhnge.WIA_GertVorhanden(VideoDeviceType) > ""
    
    'Pfadnamen des 7-Zip-Kommandozeilen-Tools aus Registry lesen
    str7ZipPfadname = OL_Anhnge.Hol7ZipPfadname
    'Controls chkZippen und cmbFormat nur aktivieren, wenn Tool verfgbar ist
    chkZippen.Enabled = str7ZipPfadname > ""
    cmbFormat.Enabled = chkZippen.Enabled
    
    'ButtonStatus-Prozedur aufrufen
    Call ButtonStatus
End Sub

Private Sub lstListe_DblClick(ByVal Cancel As MSForms.ReturnBoolean)
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    With lstListe
        'Wenn Element markiert ist, dann...
        If .ListIndex > -1 Then
            '... dessen Pfadnamen zum ffnen an ShellExecute-Funktion bergeben
            ShellExecute 0&, "open", lstListe.Text, vbNullString, vbNullString, 1
        End If
    End With
End Sub

Private Sub lstListe_KeyDown(ByVal KeyCode As MSForms.ReturnInteger, ByVal Shift As Integer)
    'Wenn Entf gedrckt und noch mindestens ein Element vorhanden ist, dann...
    If KeyCode = 46 And lstListe.ListCount > 0 Then
        '... aktuell markiertes Element aus Listenfeld lschen
        Call ElementEntfernen(lstListe.ListIndex)
    End If
End Sub

Private Sub cmdDatei_Click()
    Dim strGewhlteDatei As String
    Dim vntFeld As Variant
    Dim intI As Integer
    
    'Hinzuzufgende Datei(en) per Dateidialog whlen lassen
    strGewhlteDatei = objUniControl.FileOpen("Alle Dateien", "*.*", , CurDir, "Datei(en) einfgen", True)
    'Wenn (Mehrfach-)Auswahl getroffen, dann...
    If strGewhlteDatei > "" Then
        '... Semikolon-getrennte Pfadnamen in Array berfhren
        vntFeld = Split(strGewhlteDatei, ";")
        'Alle Array-Elemente durchlaufen
        For intI = LBound(vntFeld) To UBound(vntFeld)
            '... jeweiligen Pfadnamen in Listenfeld aufnehmen
            Call ElementHinzufgen(CStr(vntFeld(intI)))
        Next
    End If
End Sub

Private Sub cmdOrdner_Click()
    Dim strOrdner As String
    Dim strDatei As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Ordner whlen lassen
    strOrdner = objUniControl.GetFolder("Whlen Sie den Ordner, dessen Inhalt Sie einfgen mchten:", , CurDir)
    'Wenn Ordner gewhlt, dann...
    If strOrdner > "" Then
        '... Pfadname der ersten Ordnerdatei ermitteln
        strDatei = Dir(OL_Anhnge.AddSlash(strOrdner) & "*.*")
        'Solange eine Datei gefunden wurde...
        Do While strDatei > ""
            '... diese in Listenfeld aufnehmen
            Call ElementHinzufgen(OL_Anhnge.AddSlash(strOrdner) & strDatei)
            'Nchste Datei suchen
            strDatei = Dir()
        Loop
    End If
End Sub

Private Sub cmdScan_Click()
    Dim wiaImageFile As WIA.ImageFile
    Dim wiaDialog As New WIA.CommonDialog
    Dim strDateiname As String
    Dim strPfadname As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next

    'Bild mit Scanner-spezifischem WIA-Dialog in Textqualitt holen und im JPG-Format bergeben
    '(WIA-Bug: Anforderung von "TextIntent" wird ignoriert)
    Set wiaImageFile = wiaDialog.ShowAcquireImage(ScannerDeviceType, TextIntent, MinimizeSize, WIA.FormatID.wiaFormatJPEG, False, True, True)
    'Wenn WIA-Image ohne Fehler geholt, dann...
    If Err = 0 And Not wiaImageFile Is Nothing Then
        '... eindeutigen Dateinamen mit Zhler holen
        strDateiname = OL_Anhnge.HolDateinamenMitZhler(strWorkDir, "Dokument-Image", "jpg")
        'Pfadnamen auswhlen lassen
        strPfadname = objUniControl.FileSave("JPG-Dateien", "*.jpg", strDateiname, strWorkDir, "Dokument-Image speichern")
        'Wenn dieser gewhlt, dann...
        If strPfadname <> "" Then
            '... prfen, ob namensgleiche Datei bereits existiert. Falls ja, dann...
            If Dir(strPfadname) > "" Then
                '... nachfragen, ob diese berschrieben werden darf. Wenn nicht, dann...
                If MsgBox("Die gewhlte Datei existiert bereits." & vbCr & "berschreiben?", vbQuestion + vbYesNoCancel, "Dokument-Image speichern") <> vbYes Then
                    '... Prozedur verlassen
                    Exit Sub
                'Bei Erlaubnis zum berschreiben...
                Else
                    '... Datei lschen
                    Kill strPfadname
                End If
            End If
        
            'WIA-Image in Bilddatei speichern
            wiaImageFile.SaveFile strPfadname
            'Wenn Speichern ohne Fehler abluft, dann...
            If Err = 0 Then
                '... Bilddatei in Listenfeld aufnehmen
                Call ElementHinzufgen(strPfadname)
            End If
        End If
    End If
End Sub

Private Sub cmdKamera_Click()
    Dim wiaImageFile As WIA.ImageFile
    Dim wiaDialog As New WIA.CommonDialog
    Dim strDateiname As String
    Dim strPfadname As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next

    'Farbbild mit Videokamera-spezifischem WIA-Dialog holen und im JPG-Format bergeben
    Set wiaImageFile = wiaDialog.ShowAcquireImage(VideoDeviceType, ColorIntent, MinimizeSize, WIA.FormatID.wiaFormatJPEG, False, True, True)
    'Wenn WIA-Image ohne Fehler geholt, dann...
    If Err = 0 And Not wiaImageFile Is Nothing Then
        '... eindeutigen Dateinamen mit Zhler holen
        strDateiname = OL_Anhnge.HolDateinamenMitZhler(strWorkDir, "Webcam-Bild", "jpg")
        'Pfadnamen auswhlen lassen
        strPfadname = objUniControl.FileSave("JPG-Dateien", "*.jpg", strDateiname, strWorkDir, "Webcam-Bild speichern")
        'Wenn dieser gewhlt, dann...
        If strPfadname <> "" Then
            '... prfen, ob namensgleiche Datei bereits existiert. Falls ja, dann...
            If Dir(strPfadname) > "" Then
                '... nachfragen, ob diese berschrieben werden darf. Wenn nicht, dann...
                If MsgBox("Die gewhlte Datei existiert bereits." & vbCr & "berschreiben?", vbQuestion + vbYesNoCancel, "Webcam-Bild speichern") <> vbYes Then
                    '... Prozedur verlassen
                    Exit Sub
                'Bei Erlaubnis zum berschreiben...
                Else
                    '... Datei lschen
                    Kill strPfadname
                End If
            End If
        
            'WIA-Image in Bilddatei speichern
            wiaImageFile.SaveFile strPfadname
            'Wenn Speichern ohne Fehler abluft, dann...
            If Err = 0 Then
                '... Bilddatei in Listenfeld aufnehmen
                Call ElementHinzufgen(strPfadname)
            End If
        End If
    End If
End Sub

Private Sub cmdOLElement_Click()
    Dim objOLOrdner As MAPIFolder
    Dim objElement As Object
    Dim strDateiname As String
    Dim strPfadname As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Outlook-Ordner abfragen
    Set objOLOrdner = Application.GetNamespace("MAPI").PickFolder
    'Wenn kein Order gewhlt, dann ...
    If objOLOrdner Is Nothing Then
        '... Prozedur verlassen
        Exit Sub
    'Ansonsten...
    Else
        'Userform frmAnhngeElementWhlen konfigurieren
        With frmAnhngeElementWhlen
            'Gleiche Hintergrundfarbe einstellen
            .BackColor = Me.BackColor
            'Verweis auf gewhlten Outlook-Ordner in ffentlicher
            'objOLOrdner-Variable speichern
            Set .objOLOrdner = objOLOrdner
            'Userform anzeigen
            .Show
            'Verweis auf gewhltes Element aus ffentlicher
            'objGewhltesElement-Variablen lesen
            Set objElement = .objGewhltesElement
        End With
        'Userform entladen
        Unload frmAnhngeElementWhlen
        
        'Wenn Element gewhlt, dann...
        If Not objElement Is Nothing Then
            '... dessen Betreff in gltigen Namen einer MSG-Datei umwandeln
            '(durch Entfernen von nicht erlaubten Zeichen)
            strDateiname = OL_Anhnge.HolGltigenDateinamen(objElement.Subject & ".msg")
            'Pfadnamen auswhlen lassen
            strPfadname = objUniControl.FileSave("MSG-Dateien", "*.msg", strDateiname, strWorkDir, "Outlook-Element speichern")
            'Wenn dieser gewhlt, dann...
            If strPfadname <> "" Then
                '... prfen, ob namensgleiche Datei bereits existiert. Falls ja, dann...
                If Dir(strPfadname) > "" Then
                    '... nachfragen, ob diese berschrieben werden darf. Wenn nicht, dann...
                    If MsgBox("Die gewhlte Datei existiert bereits." & vbCr & "berschreiben?", vbQuestion + vbYesNoCancel, "Outlook-Element speichern") <> vbYes Then
                        '... Prozedur verlassen
                        Exit Sub
                    'Bei Erlaubnis zum berschreiben...
                    Else
                        '... Datei lschen
                        Kill strPfadname
                    End If
                End If
            
                'Outlook-Element als MSG-Datei speichern
                objElement.SaveAs strPfadname
                'Wenn Speichern ohne Fehler abluft, dann...
                If Err = 0 Then
                    '... MSG-Datei in Listenfeld aufnehmen
                    Call ElementHinzufgen(strPfadname)
                End If
            End If
        End If
    End If
End Sub

Private Sub cmdSpeichern_Click()
    Dim strDateiname As String
    Dim strZUSDatei As String
    Dim intHandle As Integer
    Dim intI As Integer
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Eindeutigen Dateinamen mit Zhler holen
    strDateiname = OL_Anhnge.HolDateinamenMitZhler(strWorkDir, "Zusammenstellung", "zus")
    'Pfadnamen der Zusammenstellungsdatei per Dateidialog whlen lassen
    strZUSDatei = objUniControl.FileSave("Zusammenstellungsdateien", "*.zus", strDateiname, strWorkDir, "Zusammenstellung speichern")
    'Wenn Datei gewhlt, dann...
    If strZUSDatei <> "" Then
        '... prfen, ob namensgleiche Datei bereits existiert. Falls ja, dann...
        If Dir(strZUSDatei) > "" Then
            '... nachfragen, ob diese berschrieben werden darf. Wenn nicht, dann...
            If MsgBox("Die gewhlte Datei existiert bereits." & vbCr & "berschreiben?", vbQuestion + vbYesNoCancel, "Zusammenstellung speichern") <> vbYes Then
                '... Prozedur verlassen
                Exit Sub
            End If
        End If
        
        'Nchstes freies Datei-Handle ermitteln
        intHandle = FreeFile
        'Datei zum Schreiben ffnen
        Open strZUSDatei For Output As #intHandle
        'Alle Listenfeldeintrge durchlaufen
        For intI = 1 To lstListe.ListCount
            'Jeweiligen Pfadnamen in Datei schreiben
            Print #intHandle, lstListe.List(intI - 1, 2)
        Next
        'Datei schlieen
        Close #intHandle
        
        'Zusammenstellung als gespeichert kennzeichnen
        blnGespeichert = True
    End If
End Sub

Private Sub cmdLaden_Click()
    Dim strZUSDatei As String
    Dim intHandle As Integer
    Dim intI As Integer
    Dim strPfadname As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Zusammenstellungsdatei per Dateidialog whlen lassen
    strZUSDatei = objUniControl.FileOpen("Zusammenstellungsdateien", "*.zus", , strWorkDir, "Zusammenstellung laden")
    'Wenn Datei gewhlt, dann...
    If strZUSDatei > "" Then
        '... nchstes freies Datei-Handle ermitteln
        intHandle = FreeFile
        'Datei zum Lesen ffnen
        Open strZUSDatei For Input As #intHandle
        'Solange Dateiende nicht erreicht...
        Do While Not EOF(intHandle)
            '... jeweils nchste Zeile einlesen
            Line Input #intHandle, strPfadname
            'Darin enthaltenen Pfadnamen in Listenfeld einfgen
            Call ElementHinzufgen(strPfadname)
        Loop
        'Datei schlieen
        Close #intHandle
        
        'Zusammenstellung als gespeichert kennzeichnen
        blnGespeichert = True
    End If
End Sub

Private Sub cmdOK_Click()
    Dim strZipDatei As String
    Dim intI As Integer
    Dim strPfadname As String
    Dim intErrCode As Integer
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Einstellung des Kontrollkstchens in Registry speichern
    SaveSetting OL_Anhnge.APPNAME, "Einstellungen", "chkZippen", chkZippen.Value
    'Einstellung des Kombinationsfelds in Registry speichern
    SaveSetting OL_Anhnge.APPNAME, "Einstellungen", "cmbFormat", cmbFormat.Value
    
    'Wenn die Zusammenstellung komprimiert werden soll, dann...
    If chkZippen.Enabled And chkZippen.Value = True Then
        '... Pfadnamen der Zip-Datei festlegen
        '(diese wird im Temp-Ordner angelegt und erhlt einen
        'eindeutigen Namen, der noch nicht fr einen vorhandenen
        'Anhang der aktuellen Nachricht in Gebrauch ist)
        strZipDatei = OL_Anhnge.AddSlash(Environ("Temp")) & OL_Anhnge.HolAnhangName(objMail, "Archiv", LCase(cmbFormat.Value))
        'Wenn ZIP-Datei existiert, dann...
        If Dir(strZipDatei) > "" Then
            '... zunchst lschen
            Kill strZipDatei
        End If
        
        'Alle Listenfeldeintrge durchlaufen
        For intI = 1 To lstListe.ListCount
            'Jeweiligen Pfadnamen in Anfhrungszeichen setzen
            strPfadname = Chr(34) & lstListe.List(intI - 1, 2) & Chr(34)

            '7-Zip-Tool aufrufen und aktuelle Datei zum Zip-File hinzufgen lassen
            '(Syntax: 7za.exe a -tzip Archivdatei GewhlteDatei)
            intErrCode = OL_Anhnge.ProgrammStarten(str7ZipPfadname, "a -t" & LCase(cmbFormat.Value) & " " & strZipDatei & " " & strPfadname)
            'Wenn 7-Zip einen Fehler meldet, dann...
            If intErrCode <> 0 Then
                '... Meldung anzeigen
                MsgBox "7-Zip-Fehler " & CStr(intErrCode) & " aufgetreten.", vbCritical, OL_Anhnge.APPNAME
                'Prozedur verlassen
                Exit Sub
            End If
        Next
        
        'Gre der Archivdatei prfen. Wenn Erlaubnis zum Einfgen erteilt, dann...
        If AnhangAnfgen(OL_Anhnge.HolDateigre(strZipDatei), True) = True Then
            '... Zip-File an aktuelle Nachricht anhngen
            objMail.Attachments.Add strZipDatei
            
            'Zip-File lschen
            Kill strZipDatei
        'Wenn User KEINE Erlaubnis erteilt, dann...
        Else
            '... nur Zip-File lschen
            Kill strZipDatei
            'Prozedur verlassen (Userform bleibt sichtbar)
            Exit Sub
        End If
    
    'Wenn die Zusammenstellung NICHT komprimiert werden soll, dann...
    Else
        '... Gre der Zusammenstellung prfen. Wenn Erlaubnis zum Einfgen erteilt, dann...
        If AnhangAnfgen(curBytesGesamt, False) = True Then
            'Alle Elemente einzeln an akuelle Nachricht anhngen
            For intI = 1 To lstListe.ListCount
                objMail.Attachments.Add lstListe.List(intI - 1, 2)
            Next
        'Wenn User KEINE Erlaubnis erteilt, dann...
        Else
            '... Prozedur verlassen (Userform bleibt sichtbar)
            Exit Sub
        End If
    End If

    'Userform entladen
    Unload Me
End Sub

Private Sub cmdCancel_Click()
    Dim intButton As Integer
    
    'Wenn Listenfeld Elemente enthlt und Zusammenstellung nicht gespeichert, dann...
    If lstListe.ListCount > 0 And blnGespeichert = False Then
        '... nachfragen, ob Zusammenstellung gespeichert werden soll
        intButton = MsgBox("Mchten Sie die aktuelle Zusammenstellung" & vbCr & "vor dem Schlieen speichern?", vbQuestion + vbYesNoCancel, OL_Anhnge.APPNAME)
        'Falls ja, dann...
        If intButton = vbYes Then
            '... Prozedur cmdSpeichern_Click aufrufen
            Call cmdSpeichern_Click
        'Falls Antwort 'Abbrechen' lautet, dann...
        ElseIf intButton = vbCancel Then
            '... Prozedur verlassen (Userform bleibt sichtbar)
            Exit Sub
        End If
    End If
    
    'Userform entladen
    Unload Me
End Sub

'**************************************************************
'Routinen
'**************************************************************

Private Sub ButtonStatus()
    'cmdOK-Schaltflche nur aktivieren, wenn Listenfeld Elemente enthlt
    cmdOK.Enabled = lstListe.ListCount > 0
    'cmdSpeichern-Schaltflche nur aktivieren, wenn Listenfeld Elemente enthlt
    cmdSpeichern.Enabled = cmdOK.Enabled
End Sub

Private Sub ElementHinzufgen(strElement As String)
    Dim curBytesDatei As Currency
    
    'Wenn Element nicht in Listenfeld vorhanden, dann...
    If ElementVorhanden(strElement) = False Then
        '... prfen, ob einzufgende Datei noch existiert. Falls ja...
        If OL_Anhnge.DateiVorhanden(strElement) = True Then
            With lstListe
                '... Dateinamen isolieren und in erste Listenfeldspalte eintragen
                .AddItem Right(strElement, Len(strElement) - InStrRev(strElement, "\"))
                'Dateigre in Bytes ermitteln
                curBytesDatei = OL_Anhnge.HolDateigre(strElement)
                'Dateigre in Spalte 2 eintragen
                .List(.ListCount - 1, 1) = Format(curBytesDatei, "0,0")
                'Vollstndigen Pfadnamen in Spalte 3 eintragen
                .List(.ListCount - 1, 2) = strElement
                
                'Letztes Element vorwhlen
                .ListIndex = .ListCount - 1
            End With
            
            'Elementzhler erhhen
            intAnzElemente = intAnzElemente + 1
            'Dateigre zu Gesamtgre addieren
            curBytesGesamt = curBytesGesamt + curBytesDatei
            'Anzahl der Elemente und Gesamtgre der Zusammenstellung in lblInfo4 anzeigen
            lblInfo4.Caption = CStr(intAnzElemente) & " Element(e) mit " & Format(curBytesGesamt, "0,0") & " Bytes (" & CStr(OL_Anhnge.Bytes2MB(curBytesGesamt)) & " MB)"
            
            'Zusammenstellung als NICHT gespeichert kennzeichnen
            blnGespeichert = False
            
        'Wenn einzufgende Datei NICHT mehr existiert, dann...
        Else
            '... entsprechenden Hinweis prsentieren
            MsgBox "Das folgende Element existiert nicht mehr:" & vbCr & Chr(34) & strElement & Chr(34), vbInformation, "Element hinzufgen"
        End If
    
    'Wenn Element schon in Listenfeld vorhanden, dann...
    Else
        '... entsprechenden Hinweis prsentieren
        MsgBox "Das folgende Element ist bereits in der Liste vorhanden:" & vbCr & Chr(34) & strElement & Chr(34), vbInformation, "Element hinzufgen"
    End If
    
    'ButtonStatus-Prozedur aufrufen
    Call ButtonStatus
End Sub

Private Sub ElementEntfernen(intListindex As Integer)
    Dim curBytesDatei As Currency

    With lstListe
        'Dateigre aus Listenfeldspalte 2 auslesen
        curBytesDatei = CCur(.List(.ListIndex, 1))
        'Markiertes Element aus Listenfeld lschen
        .RemoveItem .ListIndex
    
        'Zusammenstellung als NICHT gespeichert kennzeichnen
        blnGespeichert = False
    End With
    
    'Dateigre von Gesamtgre subtrahieren
    curBytesGesamt = curBytesGesamt - curBytesDatei
    'Elementzhler um 1 verringern
    intAnzElemente = intAnzElemente - 1
    
    'Wenn noch mindestens ein Element vorhanden ist, dann...
    If intAnzElemente > 0 Then
        '... Anzahl der Elemente und Gesamtgre der Zusammenstellung in lblInfo4 anzeigen
        lblInfo4.Caption = CStr(intAnzElemente) & " Element(e) mit " & Format(curBytesGesamt, "0,0") & " Bytes (" & CStr(OL_Anhnge.Bytes2MB(curBytesGesamt)) & " MB)"
    'Wenn nicht, dann...
    Else
        '... "0 Elemente" anzeigen
        lblInfo4.Caption = "0 Elemente"
    End If

    'ButtonStatus-Prozedur aufrufen
    Call ButtonStatus
End Sub

Private Function ElementVorhanden(strEintrag As String) As Boolean
    Dim intI As Integer
    Dim blnVorhanden As Boolean
    
    'Alle Listenelement durchlaufen
    For intI = 1 To lstListe.ListCount
        'Wenn Pfadname in Spalte 3 mit bergebenem bereinstimmt, dann...
        If LCase(lstListe.List(intI - 1, 2)) = LCase(strEintrag) Then
            '... blnVorhanden auf True setzen
            blnVorhanden = True
            'Schleife verlassen
            Exit For
        End If
    Next
    
    'Wert von blnVorhanden zurckgeben
    ElementVorhanden = blnVorhanden
End Function

Private Function AnhangAnfgen(curBytes As Currency, blnIstArchiv As Boolean) As Boolean
    Dim blnAnfgen As Boolean
    Dim dblMaxMB As Double
    Dim strMsg As String
    
    'Maximale Anhangegre (in MB) aus Registry lesen
    dblMaxMB = CDbl(GetSetting(OL_Anhnge.APPNAME, "Einstellungen", "txtMaxMB", 2))
    'Wenn Gre der Zusammenstellung oder der Archivdatei
    'dieses Limit berschreitet, dann...
    If curBytes > OL_Anhnge.MB2Bytes(dblMaxMB) Then
        '... nachfragen, ob Archiv/Zusammenstellung eingefgt werden darf. Falls ja...
        If MsgBox("Die Gre " & IIf(blnIstArchiv = True, "des komprimierten Archivs", "der ausgewhlten Dateien") & " betrgt " & CStr(OL_Anhnge.Bytes2MB(curBytes)) & " MB und bersteigt" & vbCr & "damit die von vielen E-Mail-Providern festgelegte Grenze von " & CStr(dblMaxMB) & " MB." & vbCr & "Trotzdem an Nachricht anhngen?", vbYesNoCancel + vbInformation, OL_Anhnge.APPNAME) = vbYes Then
            '... blnAnfgen auf True setzen
            blnAnfgen = True
        End If
    
    'Wenn Gre unterhalb des Limits, dann...
    Else
        '... blnAnfgen auf True setzen
        blnAnfgen = True
    End If
        
    'Wert von blnAnfgen zurckgeben
    AnhangAnfgen = blnAnfgen
End Function
