Attribute VB_Name = "OL_Anhnge"
Option Explicit

'Erfordert:
'- Installiertes Open-Source-Packprogramm 7-Zip
'- Microsoft Windows Image Acquisition Library v2.0 und Verweis darauf
'- Installiertes ActiveX-Control UniversalTools.ocx
'- Aktiven Windows Scripting Host

' 2006, Ralf Nebelo

'Anwendungsnamen festlegen
Public Const APPNAME As String = "Anhang-Manager fr Outlook"

'**************************************************************
'Makros
'**************************************************************

Public Sub SymLeisteAnzeigen(Optional objInspector As Inspector)
    Dim objCB As CommandBar

    'Fehlerverfolgung ausschalten
    On Error Resume Next

    With objInspector
        'Aktuelle Befehlsleiste aus Inspector-Fenster lschen
        .CommandBars(APPNAME).Delete
        'Befehlsleiste neu anlegen
        Set objCB = .CommandBars.Add(APPNAME, msoBarBottom, , True)
    End With

    'Befehlsleiste mit Makrostart-Schaltflche(n) bestcken.
    Call ButtonAnlegen(objCB, APPNAME, 144, "AnhngeEinfgen", False)

    'Befehlsleiste sichtbar machen
    objCB.Visible = True
End Sub

Public Sub AnhngeEinfgen()
    'Userform frmZipEinfgen aufrufen
    frmAnhnge.Show
End Sub

'**************************************************************
'WIA-Routinen
'**************************************************************

Public Function WIA_GertVorhanden(GerteTyp As WIA.WiaDeviceType) As String
    Dim wiaManager As New WIA.DeviceManager
    Dim wiaGerteInfo As WIA.DeviceInfo

    'Alle Gerte im WIA-Device-Manager durchlaufen
    For Each wiaGerteInfo In wiaManager.DeviceInfos
        'Wenn Typ des aktuellen Gerts dem angegebenen Typ entspricht, dann...
        If wiaGerteInfo.Type = GerteTyp Then
            '... ID des Gert zurckgeben
            WIA_GertVorhanden = wiaGerteInfo.DeviceID
            'Schleife verlassen
            Exit For
        End If
    Next
End Function

'**************************************************************
'Allgemeine Routinen
'**************************************************************

Private Sub ButtonAnlegen(objCB As CommandBar, strCaption As String, intFaceID As Integer, strMakro As String, blnGruppe As Boolean)
    Dim objCTL As CommandBarControl
            
    'Schaltflche anlegen
    Set objCTL = objCB.Controls.Add(Type:=msoControlButton)
    With objCTL
        .BeginGroup = blnGruppe
        'Beschriftung festlegen
        .Caption = strCaption
        'Grafisches Symbol festlegen
        .FaceId = intFaceID
        'Stil festlegen
        .Style = msoButtonIconAndCaption
        'Makro zuweisen
        .OnAction = strMakro
    End With
End Sub

Public Function Hol7ZipPfadname() As String
    Dim objWSH As Object
    Dim strPfad As String
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf Windows Scripting Host holen
    Set objWSH = CreateObject("WScript.Shell")
    
    'Installationspfad aus Registry lesen
    strPfad = objWSH.RegRead("HKLM\SOFTWARE\7-Zip\Path")
    'Wenn Kommandozeilen-Tool 7za.exe vorhanden, dann...
    If Dir(AddSlash(strPfad) & "7za.exe") > "" Then
        '... dessen Pfadnamen zurckgeben
        Hol7ZipPfadname = AddSlash(strPfad) & "7za.exe"
    'Ansonsten...
    Else
        '... leere Zeichenkette zurckgeben
        Hol7ZipPfadname = ""
    End If
    
    'Verweis auf Windows Scripting Host lschen
    Set objWSH = Nothing
End Function

Public Function AddSlash(strPfad As String) As String
    'Wenn Pfad nicht mit Backslash endet, dann...
    If Right(strPfad, 1) <> "\" Then
        '... Backslash anfgen und Pfad zurckgeben
        AddSlash = strPfad & "\"
    'Ansonsten...
    Else
        '... Pfad unverndert zurckgeben
        AddSlash = strPfad
    End If
End Function

Public Function ProgrammStarten(strProgramm As String, Optional strParameter As String = "", Optional blnSichtbar As Boolean = False) As Integer
    Dim objWSH As Object
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
        
    'Verweis auf Windows Scripting Host holen
    Set objWSH = CreateObject("WScript.Shell")

    'Programm in gewnschter Sichtbarkeit starten und ggf. Parameter
    'bergeben, Rckgabe-Code als Funktionswert zurckgeben
    ProgrammStarten = objWSH.Run(strProgramm & IIf(strParameter > "", " " & strParameter, ""), blnSichtbar, True)
    
    'Verweis auf Windows Scripting Host lschen
    Set objWSH = Nothing
End Function

Public Function HolAnhangName(objMail As MailItem, strBasisname As String, strExtension As String) As String
    Dim intZhler As Integer
    Dim strTmp As String
    
    'Endlosschleife starten
    Do
        'Laufende Bildnummer jeweils um 1 erhhen
        intZhler = intZhler + 1
        'Anhangnamen aus Basisnamen, Nummerierung und Extension zusammensetzen
        strTmp = strBasisname & Format(intZhler, "000") & "." & strExtension
    'Schleife wiederholen, bis es keinen Anhang mehr in der
    'aktuellen Nachricht gibt, der den aktuellen Namen trgt
    Loop Until AnhangVorhanden(objMail, strTmp) = False
        
    'Anhangnamen zurckgeben
    HolAnhangName = strTmp
End Function

Private Function AnhangVorhanden(objMail As MailItem, strAnhangName As String) As Boolean
    Dim objAnhang As Attachment
    
    'Alle Anhnge der Nachricht durchlaufen
    For Each objAnhang In objMail.Attachments
        'Wenn es einen Anhang mit dem gleichen Dateinamen gibt, dann...
        If LCase(objAnhang.FileName) = LCase(strAnhangName) Then
            '... den Wert True zurckgeben
            AnhangVorhanden = True
            'Schleife verlassen
            Exit For
        End If
    Next
End Function

Public Function HolDateigre(strDatei As String) As Currency
    Dim objFSO As Object
    Dim objDatei As Object
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf FileSystemObject-Objekt holen
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    'Wenn Datei existiert, dann...
    If objFSO.FileExists(strDatei) Then
        '...Verweis auf Datei holen
        Set objDatei = objFSO.GetFile(strDatei)
        'Dateigre in Bytes zurckgeben
        HolDateigre = CCur(objDatei.Size)
    End If
    
    'Verweis auf FileSystemObject-Objekt lschen
    Set objFSO = Nothing
End Function

Public Function DateiVorhanden(strDatei As String) As Boolean
    Dim objFSO As Object
    Dim objDatei As Object
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf FileSystemObject-Objekt holen
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    'Status der Existenz zurckgeben
    DateiVorhanden = objFSO.FileExists(strDatei)
    
    'Verweis auf FileSystemObject-Objekt lschen
    Set objFSO = Nothing
End Function

Public Function HolPfadEigeneDateien() As String
    Dim objWSH As Object
    
    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf Windows Scripting Host einrichten
    Set objWSH = CreateObject("WScript.Shell")

    'Pfad des Ordners "Eigene Dateien" zurckgeben
    HolPfadEigeneDateien = objWSH.SpecialFolders("MyDocuments")
    
    'Verweis auf Windows Scripting Host lschen
    Set objWSH = Nothing
End Function

Public Function MB2Bytes(dblMB As Double) As Currency
    'Anzahl der Bytes zurckgeben
    MB2Bytes = Round(dblMB * CCur(1024) * CCur(1024), 0)
End Function

Public Function Bytes2MB(curBytes As Currency) As Double
    'Anzahl der MB zurckgeben
    Bytes2MB = Round(curBytes / 1024 / 1024, 2)
End Function

Public Function HolDateinamenMitZhler(strPfad As String, strBasisname As String, strExtension As String) As String
    Dim intZhler As Integer
    Dim strDateiname As String
    
    'Schleife starten
    Do
        'Zhler erhhen
        intZhler = intZhler + 1
        'Dateinamen aus Basisnamen, dreistellig formatiertem
        'Zhler und Extension zusammensetzen
        strDateiname = strBasisname & "_" & Format(intZhler, "000") & "." & strExtension
        'Wenn keine Datei mit diesem Namen existiert, dann...
        If Dir(strPfad & IIf(Right(strPfad, 1) = "\", "", "\") & strDateiname) = "" Then
            '... Schleife verlassen
            Exit Do
        End If
    Loop Until intZhler = 100
        
    'Dateinamen zurckgeben
    HolDateinamenMitZhler = strDateiname
End Function

Public Function HolGltigenDateinamen(strMglicherDateiname As String) As String
    Dim strTmp As String
    Dim strNichtErlaubt As String
    Dim intI As Integer
    
    'bergebenen Dateinamen in strTmp kopieren
    strTmp = strMglicherDateiname
    'Nicht erlaubte Zeichen definieren
    strNichtErlaubt = "\/:*?<>|" & Chr(34)
    
    'Jedes Zeichen in strTmp durchlaufen
    For intI = 1 To Len(strTmp)
        'Wenn aktuelles Zeichen nicht erlaubt ist, dann...
        If InStr(strNichtErlaubt, Mid(strTmp, intI, 1)) > 0 Then
            '... durch Unterstrich ersetzen
            Mid(strTmp, intI, 1) = "_"
        End If
    Next
    
    'Gltigen Dateinamen zurckgeben
    HolGltigenDateinamen = strTmp
End Function

Public Function OrdnerAnlegen(strParentOrdner As String, strNeuerOrdner As String) As Boolean
    Dim objFSO As Object
    Dim strPfad As String
    Dim objParentOrdner
    Dim objNeuerOrdner

    'Fehlerverfolgung ausschalten
    On Error Resume Next
    
    'Verweis auf FileSystemObject-Objekt holen
    Set objFSO = CreateObject("Scripting.FileSystemObject")
    
    'Pfad des neuen Ordners aus Parentordnerpfad und Ordnernamen bilden
    strPfad = objFSO.BuildPath(strParentOrdner, strNeuerOrdner)

    'Wenn neuer Ordner noch nicht existiert, dann...
    If objFSO.FolderExists(strPfad) = False Then
        '... Verweis auf Parentordner holen
        Set objParentOrdner = objFSO.GetFolder(strParentOrdner)
        'Neuen Ordner als Unterordner des Parentordners anlegen
        Set objNeuerOrdner = objParentOrdner.SubFolders.Add(strNeuerOrdner)
    End If

    'Verweis auf FileSystemObject-Objekt lschen
    Set objFSO = Nothing

    'Wenn keine Probleme, True zurckgeben sonst False
    OrdnerAnlegen = Err = 0
End Function
