using System;
using System.Drawing;
using System.Windows.Forms;

namespace Gummiband
{
  public partial class Form1 : Form
  {
    Rectangle rectGummi;
    const string Titel = "Gummiband - Bereich mit Maus aufziehen";
    public Form1()
    {
      InitializeComponent();
      Text = Titel;
    }

    private void Form1_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?      
      {
        // rectGummi.Location = PointToScreen(new Point(e.X, e.Y)); 
        rectGummi.Location = Control.MousePosition;
      }
    }

    private void Form1_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?
      {
        if (this.ClientRectangle.Contains(new Point(e.X, e.Y)))
        {
          ControlPaint.DrawReversibleFrame(rectGummi, this.BackColor, FrameStyle.Dashed);
          rectGummi.Size = (Size)Control.MousePosition - (Size)rectGummi.Location;
          // rectGummi.Size = (Size) PointToScreen(new Point(e.X, e.Y)) - (Size) rectGummi.Location;
          ControlPaint.DrawReversibleFrame(rectGummi, this.BackColor, FrameStyle.Dashed);
          Text = rectGummi.ToString();
        }
      }
    }

    private void Form1_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
    {
      if ((e.Button & MouseButtons.Left) > 0)  // linke Maustaste?      
      {
        ControlPaint.DrawReversibleFrame(rectGummi, this.BackColor, FrameStyle.Dashed);
        rectGummi.Size = new Size(0, 0);
        Text = Titel;
      }
    }

    private void timer1_Tick(object sender, EventArgs e)
    {
      label1.Text = DateTime.Now.ToLongTimeString();
    }

    private void Form1_Paint(object sender, PaintEventArgs e)
    {
      string zeit = DateTime.Now.ToLongTimeString();
      Font fnt = new Font("Times", 48);

      SizeF sz = this.ClientRectangle.Size - e.Graphics.MeasureString(zeit, fnt);
      PointF p = new PointF(sz.Width / 2, sz.Height / 2);
      e.Graphics.DrawString(zeit, fnt, Brushes.Black, p);
    }
  }
}