#include <QApplication>
#include <QTranslator>
#include "ExpenseHelper.h"
#include <QMessageBox>
#include <QSqlError>

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);

    QTranslator* translator = new QTranslator( &a );
    translator->load( "expensehelper_de.qm" );
    a.installTranslator( translator );

    // Read the exchange rates
    ExchangeRateReader reader;

    // Set up the database connection
    QSqlDatabase database = QSqlDatabase::addDatabase( "QSQLITE" );
    database.setDatabaseName( "expenses.db" );
    if( !database.open() ) {
        QMessageBox::critical( 0, QObject::tr( "Error" ), QObject::tr( "Could not open database; driver said: %1, database said: %2" ).arg( database.lastError().driverText() ).arg( database.lastError().databaseText() ) );
        return -1;
    }

    ExpenseHelper expenseHelper( reader.rates() );
    QObject::connect( &reader, SIGNAL( ratesParsed() ),
                      &expenseHelper, SLOT( slotRatesParsed() ) );
    return expenseHelper.exec();
}
