#ifndef EXCHANGEWIDGET_H
#define EXCHANGEWIDGET_H

#include <QWidget>
class QLabel;
class QLineEdit;
class QDateEdit;

class ExchangeWidget : public QWidget
{
    Q_OBJECT

public:
    explicit ExchangeWidget( QWidget* parent = 0 );

    void reset();

    QDateEdit* dateEdit() const { return mDateEdit; }
    QLineEdit* currencyEdit() const { return mCurrencyEdit; }
    QLabel* rateField() const { return mRateField; }

signals:
    void rateChanged( double );

private slots:
    void slotRecompute();

private:
    QDateEdit* mDateEdit;
    QLineEdit* mCurrencyEdit;
    QLabel* mRateField;
};


#endif /* EXCHANGEWIDGET_H */

