/* $Id: CFileNTFS.h 776 2006-04-27 10:38:18Z olau $ */

// Copyright (c) 2006 Caspar Gorvin, http://www.gorvin.de/
// Copyright (c) 2006 Heise Zeitschriften Verlag, http://www.heise.de/
// All rights reserved.

#pragma once

class CFileNTFS
{
public:
	CFileNTFS(void);
	virtual ~CFileNTFS(void);

	// File Stream ID:
	// Jedem Stream ist eine WIN32_STREAM_ID Struktur vorangestellt,
	// die an 32-bit (DWORD) Grenzen ausgerichtet ist.
	// Die Struktur ist zwischen 24 und 616 Bytes lang, abhngig
	// von dem Vorhandensein und der Lnge des Stream-Namens.
	// Fr unsere Implementierung nutzen wir eine abgewandelte
	// Struktur von fester, maximaler Lnge.

	typedef struct FILE_STREAM_ID {			
		DWORD dwStreamId;					 // Stream-Art
		DWORD dwStreamAttributes;			  
		LARGE_INTEGER Size;					 // Streamgre in Bytes
		DWORD dwStreamNameSize;				 // Lnge des Namens in Bytes
		WCHAR cStreamName[MAX_PATH + 36 + 2];// Unicode Stream-Name
		// ":Stream-Name:Stream-Typ"
	} FILE_STREAM_ID;					

	HRESULT CreateFile(
		LPCWSTR lpFileName,
		DWORD dwDesiredAccess,					
		DWORD dwShareMode,
		DWORD dwCreationDisposition,
		DWORD dwFlagsAndAttributes
		);

	HRESULT ReadNextStreamInfo(
		FILE_STREAM_ID* pStreamInfo
		);

	HRESULT CloseFile();

private:

	WCHAR m_wszFileName[MAX_PATH];				// Dateiname
	HANDLE m_hFile;								// Datei-Handle
	LARGE_INTEGER m_lnOffsetToNextStreamID;		// Seek-Offset
	LPVOID m_lpReadContext;						// Context Pointer
};
