/* $Id: ObjectCounter.cpp 784 2006-05-03 11:48:41Z olau $ */

// Copyright (c) 2006 Caspar Gorvin, http://www.gorvin.de/
// Copyright (c) 2006 Heise Zeitschriften Verlag, http://www.heise.de/
// All rights reserved.

#include "stdafx.h"
#include "ObjectCounter.h"

// *****************************************************************
// Globaler Objekt-Zhler
// *****************************************************************
// Globale Variablen mssen durch Synchronisation gegen 
// berlappenden Zugriff aus mehreren Threads geschtzt werden!
//
// Der globale Objekt-Zhler zhlt die Anzahl
// der aktiven COM-Objekte der DLL.
// Er wird in folgenden Funktionen hoch- oder runtergezhlt:
// - Konstruktor und Destruktor von CoClassFactory
// - Konstruktor und Destruktor von CoStreamColumns
// - CoClassFactory::Lock()

static LONG volatile nObjectCount = 0;

void IncrementObjectCounter(void)
{
	InterlockedIncrement(&nObjectCount);
}

void DecrementObjectCounter(void)
{
	InterlockedDecrement(&nObjectCount);
}

bool ObjectCounterIsNull(void)
{
	return (nObjectCount == 0);
}
