/* $Id: ctShellExtension.cpp 784 2006-05-03 11:48:41Z olau $ */

// Copyright (c) 2006 Caspar Gorvin, http://www.gorvin.de/
// Copyright (c) 2006 Heise Zeitschriften Verlag, http://www.heise.de/
// All rights reserved.

#include "stdafx.h"
#include "CoClassFactory.h"
#include "ctShellExtensionGUID.h"
#include "ObjectCounter.h"


// DllMain() wird beim Laden und Entladen der Dll aufgerufen 

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call) 
	{
		case DLL_PROCESS_ATTACH:	// Die DLL wird geladen...

#ifdef _DEBUG				
			MessageBox(NULL, L"Die DLL wird geladen ...", 
			  L"ctShellExtension", 
			  MB_OK | MB_ICONINFORMATION);
#endif
			break;

		case DLL_THREAD_ATTACH:	// Ein neuer Thread wird erzeugt ...
			break;

		case DLL_THREAD_DETACH:	// Ein Thread wird beendet ...
			break;

		case DLL_PROCESS_DETACH:	// Die Dll wird entladen ...

#ifdef _DEBUG
			MessageBox(NULL, L"Die DLL wird entladen ...", 
			  L"ctShellExtension", 
			  MB_OK | MB_ICONINFORMATION);
#endif
			break;

		default:
			break;
	}    
	return TRUE;
}

// DllCanUnloadNow() wird aufgerufen, um zu prfen,
// ob die DLL entladen werden kann 

STDAPI DllCanUnloadNow()
{
	if (ObjectCounterIsNull())
		return S_OK;
	else return S_FALSE;
}


// DllGetClassObject() wird aufgerufen, um ein Objekt
// der Klasse CoColumnHandler zu erzeugen 

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, void** ppv)
{
	IUnknown* pFactory;

	// Prfe die Eingabeparameter und erzeuge die Class Factory 
	if (ppv == NULL)
		return E_INVALIDARG;

	if (rclsid == CLSID_CoStreamColumns) 
	{
		pFactory = new CoClassFactory();
		if (!pFactory)
			return E_OUTOFMEMORY;
	}
	else
		return CLASS_E_CLASSNOTAVAILABLE;

	// Erfrage den gewnschten Interface-Pointer
	// auf das neu erzeugte Class-Factory-Objekt 
	HRESULT hr = pFactory->QueryInterface(riid, ppv);
	if (FAILED(hr))
		delete pFactory;
	return hr;
}
