/* $Id: CoStreamColumns.h 784 2006-05-03 11:48:41Z olau $ */

// Copyright (c) 2006 Caspar Gorvin, http://www.gorvin.de/
// Copyright (c) 2006 Heise Zeitschriften Verlag, http://www.heise.de/
// All rights reserved.

#pragma once

class CoStreamColumns :	public IColumnProvider
{
public:
	CoStreamColumns(void);
	virtual ~CoStreamColumns(void);

	// IUnknown
	STDMETHODIMP QueryInterface(REFIID riid, void** ppvObject);
	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();

	// IColumnProvider
	STDMETHODIMP Initialize(LPCSHCOLUMNINIT psci);
	STDMETHODIMP GetColumnInfo(DWORD dwIndex, SHCOLUMNINFO* psci);
	STDMETHODIMP GetItemData(LPCSHCOLUMNID pscid, LPCSHCOLUMNDATA pscd, VARIANT* pvarData);

private:
	// Anzahl von Client-Referenzen auf Objekte dieser Klasse
	// (wird zur Implementierung von IUnknown bentigt)
	int m_nRefCount;

	// Spalten-Zhler
	// (wird zur Implementierung von IColumnProvider bentigt)
	DWORD m_dwColumnCount;
	static const enum _supported_columns {
		PID_NUMBER_OF_STREAMS,
		PID_STREAM_SIZE,
		PID_MAX
	};

	// Informationen ber die zuletzt geprfte Datei
	WCHAR m_wszFile[MAX_PATH];
	
	DWORD m_dwStreamCount;
	LARGE_INTEGER m_lnStreamSize;

	// Variablen fr die formatierte Ausgabe der Streamgre
	NUMBERFMT m_stFormat;           // Zahlenformatdefinition
	WCHAR m_wszDigits[21];          // maximal 20 Dezimalstellen
	WCHAR m_wszFormatedDigits[27];  // plus 6 Tausendertrennzeichen
	BSTR m_bstrVal;                 // COM-spezifischer String

	// Funktion fr das Zusammentragen der Stream-Informationen
	HRESULT GetStreamData(LPCWSTR wszFile);
};
