//Skript für Heise-Multisuche

var suchform, debug, trefferanzeige, Suche;

//ausgelöst beim Laden der Seite:
window.addEventListener('load', function(ev) {
 //definiert ein paar Abkürzungen
 suchform = document.getElementById('suchform'); //Suchformular
 //Debug-Konsole - es gibt keine Alerts!
 debug = document.getElementById('debug').firstChild;
 debug.nodeValue = '';
 trefferanzeige = document.getElementById('trefferanzeige');

 //Host und Pfad zu Such- und Trefferseiten der vier Heise-Angebote
 Suche = new Object;
 Suche.host = 'http://www.heise.de';
 Suche.get = '?T=';
 Suche.heise_online = new Object;
 Suche.heise_online.name = 'heise_online';
 Suche.heise_online.ort = '/newsticker/search.shtml';
 Suche.heise_online.link = '/newsticker/';
 Suche.heise_online.anzeige = true; //Suchtreffer sichtbar
 Suche.heise_online.ajax = new Object;
 Suche.ct = new Object;
 Suche.ct.name = 'ct';
 Suche.ct.ort = '/ct/inhverz/search.shtml';
 Suche.ct.link = '';
 Suche.ct.anzeige = true;
 Suche.ct.ajax = new Object;
 Suche.ix = new Object;
 Suche.ix.name = 'ix';
 Suche.ix.ort = '/ix/iXInhalt/search.shtml';
 Suche.ix.link = '';
 Suche.ix.anzeige = true;
 Suche.ix.ajax = new Object;
 Suche.telepolis = new Object;
 Suche.telepolis.name = 'telepolis';
 Suche.telepolis.ort = '/tp/r4/html/such.html';
 Suche.telepolis.link = '/tp/r4/html/';
 Suche.telepolis.anzeige = true;
 Suche.telepolis.ajax = new Object;


 //ausgelöst beim Abschicken des Suchformulars
 suchform.addEventListener('submit', function(ev) {
  Suche.suchbegriff = document.getElementById('suchbegriff').value;
  if(!Suche.suchbegriff) return false;
  //Zahl der anzuzeigenden Treffer, als Standard 3
  Suche.angezeigt = 3;
  if(tmp = parseInt(document.getElementById('anzahl').value)) {
   if(tmp != 'NaN' && tmp < 10) Suche.angezeigt = tmp;
  }

  //für alle vier Checkboxen:
  for(i=0; i<suchform.wo.length; i++) {
   eval('var Bereich = Suche.' + suchform.wo[i].value);
   //Bereich ist jetzt Suche.heise_online oder Suche.ct etc.
   //Container für Suchtreffer bereitstellen und leeren
   var container = document.getElementById(Bereich.name);
   while(container.hasChildNodes()) {
    container.removeChild(container.firstChild);
   }
   if(!suchform.wo[i].checked) continue;
   if(!Bereich) continue;
   //Checkbox angekreuzt? -> Ajax-Anfrage starten
   Bereich.ajax = new XMLHttpRequest();
   Bereich.ajax.open('GET', Suche.host + Bereich.ort + Suche.get + Suche.suchbegriff, true);
   Bereich.ajax.send(null);
   //Ereignishandler: Die Funktion _ajax0/1/2/3 wird ausgelöst, wenn sich
   //der Ajax-Status ändert; sie löst die Funktion ajax('Bereichsname') aus
   Bereich.ajax.onreadystatechange = new Function ("_ajax" + i, "ajax('" + Bereich.name + "');");
  }
 }, false);
}, false);


//ausgelöst per Ereignishandler, wenn sich der Ajax-Status ändert
function ajax(name) {
 eval('var Bereich = Suche.' + name);
  //Bereich ist wiederum Suche.heise_online oder Suche.ct etc.
  //readyState 4 = Übertragung vollständig
  if(Bereich.ajax.readyState == 4) {
  //HTTP-Übertragungsstatus 200 = ok; sonst Debug-Hinweis
  if (Bereich.ajax.status != 200 && Bereich.ajax.status != 0) {
   debug.nodeValue += "Probleme: " + Bereich.ort + ' ' + Bereich.ajax.statusText;
   return false;
  }
  //blendet Trefferanzeige (falls noch nicht passiert) ein
  trefferanzeige.style.display = 'block';
  //Container für Suchtreffer einblenden
  var container = document.getElementById(Bereich.name);
  container.style.display = 'block';
  //versieht den Container mit Überschrift und "Ausblenden"-Link
  //sieht komplizierter aus als es ist - DOM ist ein wenig schwerfällig
  var neu_h2 = document.createElement('h2');
  neu_h2.appendChild(document.createTextNode(Bereich.name));
  var ausbl = document.createElement('a');
  var ausbl_href = document.createAttribute('href');
  ausbl.setAttributeNode(ausbl_href);
  var ausbl_cl = document.createAttribute('class');
  ausbl_cl.nodeValue = 'ausblenden';
  ausbl.setAttributeNode(ausbl_cl);
  ausbl.appendChild(document.createTextNode('Ausblenden'));

  //Ereignishandler, ausgelöst durch Anklicken von "Ausblenden"
  //<a href="javascript:tuwas('damit')"> klappt nicht bei Widgets
  //Die Funktion macht eine der vier Trefferlisten unsichtbar
  ausbl.addEventListener('click', function(ev){
   if(Bereich.anzeige) {
    //Liste sichtbar -> unsichtbar machen
    Bereich.anzeige = false;
    //firstChild: h2-Überschrift;
    //nextSibling: Absatz mit Trefferzahl;
    //nextSibling (2): ol-Liste mit Treffern
    container.firstChild.nextSibling.nextSibling.style.display = 'none';
    //firstChild von h2: Überschrifttext
    //nextSibling: Link "Aus/Einblenden"
    //firstChild: Linktext
    container.firstChild.firstChild.nextSibling.firstChild.nodeValue = 'Einblenden';
   } else {
    //Liste unsichtbar -> sichtbar machen
    Bereich.anzeige = true;
    container.firstChild.nextSibling.nextSibling.style.display = 'block';
    container.firstChild.firstChild.nextSibling.firstChild.nodeValue = 'Ausblenden';
   }
  }, false);

  neu_h2.appendChild(ausbl);
  container.appendChild(neu_h2);
  //Absatz für die Suchtrefferzahl
  var neu_p = document.createElement('p');
  container.appendChild(neu_p);
  var text = Bereich.ajax.responseText;
  //text enthält die Suchtrefferseite als Text
  //responseXML klappt nur bei wohlgeformtem XML
  //und macht das "Content Scraping" auch nicht viel leichter.
  //ermittelt die Zeile mit der Trefferzahl - die Treffer kommen danach
  var trzeile = text.match(/<h4>\s*\d+\s*Treffer\s*\(\d+\s*\%\)/);
  var treffertext;
  if(!trzeile) {
   treffertext = 'Keine Treffer!';
  } else {
   var trefferzahl = trzeile[0].match(/\b\d+\b/g);
   treffertext = trefferzahl[0] + ' Treffer (' + trefferzahl[1] + '%)'
  }
  //gibt Trefferzahl aus
  neu_p.appendChild(document.createTextNode(treffertext));
  if(!trzeile) return false;
  //legt ol-Liste an
  var neu_ol = document.createElement('ol');
  container.appendChild(neu_ol);
  var splitter = text.split(trzeile, 2);
  //wirft alles weg, was vor der Trefferzahl steht
  text = splitter[1];
  //keine Absätze, nur noch ein Leerzeichen
  text = text.replace(/\s+/g, ' ');
  splitter = '';
  var Alletreffer, Einzeltreffer;
  //Die Suchtreffer von heise online und Telepolis gleichen sich,
  //ebenso die von c't und iX
  if(Bereich.name == 'heise_online' || Bereich.name == 'telepolis') {
   text.match(/<li>(.+)<\/li>/);
   text = RegExp.$1;
   //text sollte jetzt nur noch alle Listenpunkte enthalten
   if(!text) return false;
   text = text.replace(/<\/?b( [^>]*)?>/g, ''); //löscht <b>
   text = text.replace(/\s+</g, '<'); //löscht Leerzeichen um Tags
   text = text.replace(/>\s+/g, '>');
   text = text.replace(/<A HREF=\"([^\"]+)\">/g, '$1<>'); //Linkadresse
   text = text.replace(/\(([\d\.]+), ([^\)]+)\)/g, '$1<>$2'); //Autor, Datum
   text = text.replace(/<\/li><li>/g, '!!!'); //Trennzeichen für Datensätze
  } else {
   text.match(/<tr>(.+)<\/tr>/);
   text = RegExp.$1;
   //hier hängt noch ein langer Rattenschwanz an text
   if(!text) return false;
   text = text.replace(/<\/?font[^>]*>/g, ''); //löscht <font> (igitt)
   text = text.replace(/<img[^>]+>/g, ''); //löscht <img>
   text = text.replace(/ align=\"\w+\"/g, ''); //löscht align-Attribute
   text = text.replace(/\s+</g, '<'); //löscht Leerzeichen um Tags
   text = text.replace(/>\s+/g, '>');
   text = text.replace(/<\/b><br><b>/g, '. '); //Titel. Untertitel
   text = text.replace(/<a href=\"([^\"]+)\">/g, '$1'); //Adresse (online oder Kiosk)
   text = text.replace(/<\/td><\/tr><tr><td>/g, '!!!'); //Trennzeichen für Datensätze
  }
  //der Rest gilt für alle Suchtreffer:
  text = text.replace(/<\/?[^>]+>/g, '<>'); //ersetzt Tags durch Trennzeichen <>
  text = text.replace(/(<>)+/g, '<>'); //ersetzt mehrfache Trennzeichen
  text = text.replace(/^<>/, ''); //löscht Trennzeichen am Anfang und Ende
  text = text.replace(/<>$/, '');
  text = text.replace(/<>(kaufen|online)<>/g, '<>'); //c't-Kiosk und online
  text = text.replace(/Seite<>1<>.+/, '!!!'); //letzter Suchtreffer bei c't und iX
  text = text.replace(/,(\w)/g, ', $1'); //c't-Stichworte sind oft nicht durch Leerzeichen getrennt
  //Umlaute und Sonderzeichen werden nicht interpretiert -> händische Ersetzung
  text = text.replace(/&auml;/g, 'ä');
  text = text.replace(/&ouml;/g, 'ö');
  text = text.replace(/&uuml;/g, 'ü');
  text = text.replace(/&Auml;/g, 'Ä');
  text = text.replace(/&Ouml;/g, 'Ö');
  text = text.replace(/&Uuml;/g, 'Ü');
  text = text.replace(/&szlig;/g, 'ß');
  text = text.replace(/&ndash;/g, '–');
  text = text.replace(/&amp;/g, '&');
  text = text.replace(/&(\w)\w+;/g, '$1'); //ersetzt alle sonstigen HTML-Entities
  Alletreffer = text.split("!!!", Suche.angezeigt+1); //Datensätze auftrennen

  //angezeigte Trefferzahl darf höchstens so groß sein wie die Zahl der gefundenen Treffer
  Bereich.angezeigt = Suche.angezeigt;
  if(Alletreffer.length <= Suche.angezeigt) {Bereich.angezeigt = Alletreffer.length - 1}

  //weist den Suchtreffer einem Objekt zu
  for(i=0; i<Bereich.angezeigt; i++) {
   var suchtreffer = new Object;
   //trennt Datenfelder auf
   Einzeltreffer = Alletreffer[i].split('<>');
   //die Reihenfolge der Datenfelder unterscheidet sich
   if(Bereich.name == 'heise_online' || Bereich.name == 'telepolis') {
    suchtreffer.url = Suche.host + Bereich.link + Einzeltreffer[0];
    suchtreffer.titel = Einzeltreffer[1];
    suchtreffer.datum = Einzeltreffer[2];
    suchtreffer.autor = Einzeltreffer[3];
    suchtreffer.kurztext = Einzeltreffer[4];
   } else {
    Einzeltreffer[0] = Einzeltreffer[0].replace(/^\d+\. /, ''); //löscht führende Ordnungszahl
    suchtreffer.autor = Einzeltreffer[0];
    suchtreffer.titel = Einzeltreffer[1];
    suchtreffer.kurztext = Einzeltreffer[2];
    suchtreffer.datum = Einzeltreffer[3];
    //URL kann im 5. oder im 6. Element stehen (online oder Kiosk) oder fehlen
    if(!Einzeltreffer[4]) {
     suchtreffer.url = '';
    } else {
     suchtreffer.url = Einzeltreffer[5]? Suche.host + Einzeltreffer[5] : Suche.host + Einzeltreffer[4];
    }
   }

   //Ausgabe: legt ein li-Element unterhalb von ol an
   var neu_li = document.createElement('li');
   neu_ol.appendChild(neu_li);
   //baut Artikel-/Meldungstitel in Link oder in <strong>-Element ein
   var titel = '';
   if(suchtreffer.url) {
    titel = document.createElement('a');
    var linkziel = document.createAttribute('href');
    linkziel.nodeValue = suchtreffer.url;
    titel.setAttributeNode(linkziel);
   } else {
    titel = document.createElement('strong');
   }
   titel.appendChild(document.createTextNode(suchtreffer.titel + ':'));
   neu_li.appendChild(titel);
   //gibt Kurztext, Autor und Datum aus
   neu_li.appendChild(document.createTextNode(' ' + suchtreffer.kurztext + ' (' + suchtreffer.autor + ', ' + suchtreffer.datum + ')'));
  }
 }
}
