/* $Id: getopt.c 739 2006-04-06 11:10:36Z olau $ */

#include <stdio.h>
#include <io.h>
#include <string.h>

#define ERR(s, c) \
   if (opterr) \
   { \
      char errbuf[2]; \
      errbuf[0] = (char)c; errbuf[1] = '\n'; \
      (void) _write(2, argv[0], (unsigned) strlen(argv[0])); \
      (void) _write(2, s, (unsigned) strlen(s)); \
      (void) _write(2, errbuf, 2); \
   }

int   opterr = 1;
int   optind = 1;
int   optopt;
char  *optarg;

int getopt(int argc, char **argv, char *opts)
{
   int sp = 1;
   int c;
   char *cp;

   if (sp == 1)
   {
      if (optind >= argc ||
         argv[optind][0] != '-' ||
         argv[optind][1] == '\0')
         return(EOF);
      else if (strcmp(argv[optind], "--") == 0)
      {
         optind++;
         return(EOF);
      }
   }
   optopt = c = argv[optind][sp];
   if (c == ':' || (cp=strchr(opts, c)) == 0)
   {
      ERR(": illegal option -- ", c);
      if(argv[optind][++sp] == '\0')
      {
         optind++;
         sp = 1;
      }
      return('?');
   }
   if (*++cp == ':')
   {
      if(argv[optind][sp+1] != '\0')
         optarg = &argv[optind++][sp+1];
      else if(++optind >= argc)
      {
         ERR(": option requires an argument -- ", c);
         sp = 1;
         return('?');
      }
      else
         optarg = argv[optind++];
      sp = 1;
   }
   else
   {
      if (argv[optind][++sp] == '\0')
      {
         sp = 1;
         optind++;
      }
      optarg = NULL;
   }
   return(c);
}
