/* $Id: openmp2.c 854 2006-06-22 08:54:10Z olau $ */

#include <stdio.h>
#include <omp.h>
#include "ompdefs.h"
#include "globaldefs.h"

#define A()   do_work("A", omp_get_thread_num(), omp_get_num_threads())
#define B()   do_work("B", omp_get_thread_num(), omp_get_num_threads())
#define C()   do_work("C", omp_get_thread_num(), omp_get_num_threads())
#define D()   do_work("D", omp_get_thread_num(), omp_get_num_threads())
#define E()   do_work("E", omp_get_thread_num(), omp_get_num_threads())
#define F()   do_work("F", omp_get_thread_num(), omp_get_num_threads())
#define G()   do_work("G", omp_get_thread_num(), omp_get_num_threads())
#define H()   do_work("H", omp_get_thread_num(), omp_get_num_threads())


void do_work(const char *s, int myrank, int mysize)
{
  volatile int i;

  printf("Dies ist Thread %2d von %2d bei Aufgabe %s\n",
    myrank, mysize, s);
  for (i = 0; i < DEFAULT_ITERATIONS; i++)
    /* nix besonderes tun, einfach nur zhlen */;
}



int main(int argc, char *argv[])
{
  printf("Anzahl der Prozessoren: %d\n",
	 omp_get_num_procs());
#pragma omp parallel sections
  {
    { A(); B(); }
#pragma omp section 
    { C(); D(); }
#pragma omp section 
    { E(); F(); }
#pragma omp section 
    { G(); H(); }
  } /* end pragma omp parallel sections */
  printf("Fertig.\n");
  return 0;
}
