/* $Id: pi-openmp.c 854 2006-06-22 08:54:10Z olau $ */

#include <stdio.h>
#include <math.h>
#ifdef _OPENMP
#include <omp.h>
#include "ompdefs.h"
#endif
#include "globaldefs.h"

#ifdef WIN32
/* Laut der OpenMP-Spezifikation werden die in einer reduction-Klausel
   erwhnten Variablen anhand des reduction-Operators automatisch mit
   einem neutralen Wert initialisiert, bei "+" und "-" zum Beispiel mit
   0, bei "*" mit 1, und so weiter. Im C/C++-Compiler aus Microsoft
   Visual Studio 2005 ist diese Vorgabe aber nicht korrekt implemen-
   tiert. In der Folge beanstandet er die fehlende Initialisierung der
   lokalen Variablen sum mit der Warnung 4700. Das folgende Pragma
   schaltet sie einfach ab.
*/
#pragma warning(disable : 4700)
#endif

int main(int argc, char *argv[]) {
  int i;
  double w, x, sum, pi;
  double t;

#ifdef _OPENMP
  printf("Anzahl Prozessoren: %d\n", omp_get_num_procs());
  t = omp_get_wtime();
#endif
  w = 1.0 / DEFAULT_ITERATIONS;
#pragma omp parallel private(x) shared(w) 
  {
# ifdef DEBUG
    printf("Dies ist Thread %3d von %3d\n",
      omp_get_thread_num(),
      omp_get_num_threads());
# endif
#pragma omp for reduction(+:sum) schedule(runtime)
    for (i = 1; i <= DEFAULT_ITERATIONS; i++) {
      x = w * ((double)i - 0.5);
      sum += f(x);
    }
  }
  pi = w * sum;
  printf("pi = %.13lf (Fehler = %.13lf)\n", pi, pi - PI);
#ifdef _OPENMP
  printf("Ausfuehrungsdauer: %.2lf ms\n\n", 1000 * (omp_get_wtime() - t));
#endif
  return 0;
}
