/* $Id: abc.c 886 2006-07-09 17:51:52Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#define NUM_THREADS         3

typedef struct _threadparam {
  int myrank;
} THREADPARAM;

void *aThread(void *params) {
  printf("%c", 'A' + ((THREADPARAM *) params)->myrank);
  return NULL;
}

int main(int argc, char *argv[]) {
  pthread_t tid[NUM_THREADS];
  THREADPARAM param[NUM_THREADS];
  int i;
  int rc;

  /* Threads starten */
  for (i = 0; i < NUM_THREADS; ++i) {
    param[i].myrank = i;
    rc = pthread_create(&tid[i], NULL, aThread, &param[i]);
    if (rc != 0)
      err_abort(rc, "pthread_create() fehlgeschlagen");
  }

  /* auf Beendigung der Threads warten */
  for (i = 0; i < NUM_THREADS; ++i) {
    rc = pthread_join(tid[i], NULL);
    if (rc != 0)
      err_abort(rc, "pthread_join() fehlgeschlagen");
  }

  printf("\n");
  return 0;
}
