/* $Id: cancel.c 910 2006-07-13 07:36:36Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif


void cleanup_handler(void *params)
{
  printf("Ordnung schaffen ...\n");
}

void *thread(void *params)
{
  int i;
  pthread_cleanup_push(cleanup_handler, NULL);
  printf("Thread tut was ...\n");
  /* Schleifen drehen bis zum Sanktnimmerleinstag */
  for (i = 0; ; ++i) {
    /* alle 10000 Runden prfen, ob der Thread abgebrochen wurde */
    if (i % 10000 == 0)
      pthread_testcancel();
  }
  printf("Thread beendet sich.\n");
  pthread_cleanup_pop(1);
  return NULL;
}

int main(int argc, char *argv[])
{
  pthread_t tid;
  int rc;

  /* Thread starten */
  rc = pthread_create(&tid, NULL, thread, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_create() fehlgeschlagen");

  /* vor dem Thread abbrechen zwei Sekunden warten */
  printf("Hauptprogramm: Zwei Sekunden warten ...\n");
#ifdef WIN32
  Sleep(2000);
#else
  sleep(2);
#endif

  printf("Hauptprogramm: Thread abbrechen ...\n");
  rc = pthread_cancel(tid);
  if (rc != 0)
    err_abort(rc, "pthread_cancel() fehlgeschlagen");

  printf("Hauptprogramm: Auf Thread warten ...\n");
  rc = pthread_join(tid, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_join() fehlgeschlagen");

  printf("Fertig.\n");
  return 0;
}
