/* $Id: cancel2.c 904 2006-07-11 08:14:06Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif


typedef struct _wait_t {
  pthread_mutex_t mutex;
  pthread_cond_t  cond;
} wait_t;

static wait_t wait =
  { PTHREAD_MUTEX_INITIALIZER, PTHREAD_COND_INITIALIZER };

void cleanup_handler(void *params)
{
  int rc;
  printf("Ordnung schaffen ...\n");
  rc = pthread_mutex_unlock(&wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_mutex_unlock() fehlgeschlagen");
}

void *thread(void *params)
{
  int rc;
  pthread_cleanup_push(cleanup_handler, NULL);
  printf("Thread wartet auf Signal ...\n");
  rc = pthread_mutex_lock(&wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_mutex_lock() fehlgeschlagen");
  rc = pthread_cond_wait(&wait.cond, &wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_cond_wait() fehlgeschlagen");
  rc = pthread_mutex_unlock(&wait.mutex);
  printf("Thread hat Mutex entsperrt.\n");
  if (rc != 0)
    err_abort(rc, "pthread_mutex_unlock() fehlgeschlagen");
  printf("Thread beendet sich.\n");
  pthread_cleanup_pop(1);
  return NULL;
}

int main(int argc, char *argv[])
{
  pthread_t tid;
  int rc;
  // int state, type;

  /* Thread starten */
  rc = pthread_create(&tid, NULL, thread, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_create() fehlgeschlagen");

  // pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, &state);
  // pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, &type);

  /* eine Sekunde warten, dann Thread abbrechen */
  printf("Hauptprogramm: Zwei Sekunden warten ...\n");
#ifdef WIN32
  Sleep(2000);
#else
  sleep(2);
#endif

  printf("Hauptprogramm: Thread abbrechen ...\n");
  rc = pthread_cancel(tid);
  if (rc != 0)
    err_abort(rc, "pthread_cancel() fehlgeschlagen");

  printf("Hauptprogramm: Auf Thread warten ...\n");
  rc = pthread_join(tid, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_join() fehlgeschlagen");

  printf("Fertig.\n");
  pthread_exit(NULL);
  return 0;
}
