/* $Id$ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif


void cleanup_handler(void *params)
{
  printf("Ordnung schaffen ...\n");
}


void *thread(void *params)
{
  pthread_cleanup_push(cleanup_handler, NULL);
  printf("Thread wartet vier Sekunden ...\n");
#ifdef WIN32
  Sleep(4000);
#else
  sleep(4);
#endif
  printf("Thread beendet sich.\n");
  pthread_cleanup_pop(1);
  return NULL;
}

int main(int argc, char *argv[])
{
  pthread_t tid;
  int rc;

  printf("Thread starten ...\n");
  /* Thread starten */
  rc = pthread_create(&tid, NULL, thread, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_create() fehlgeschlagen");

  pthread_detach(tid);

  printf("main() wartet zwei Sekunden ...\n");
#ifdef WIN32
  Sleep(2000);
#else
  sleep(2);
#endif

  printf("Thread wurde abgewuergt.\n");
  pthread_exit(NULL);
  return 0;
}
