/* $Id: pi.c 910 2006-07-13 07:36:36Z olau $ */

#include <stdio.h>
#include <pthread.h>
#include <math.h>

#include "../globaldefs.h"
#include "../helper.h"

#ifdef WIN32
#include <windows.h>
#else
#include <malloc.h>
#endif

#define DEFAULT_NUMTHREADS   2

typedef struct _calcthreadparam
{
  CACHE_ALIGN int myrank;
  int size;
  int iterations;
} CALCTHREADPARAM;

typedef struct _calcthreadresult
{
  CACHE_ALIGN volatile double sum;
} CALCTHREADRESULT;


void *calcthread(void *params)
{
  int i;
  double x;
  int myrank = ((CALCTHREADPARAM *) params)->myrank;
  int size = ((CALCTHREADPARAM *) params)->size;
  int iterations = ((CALCTHREADPARAM *) params)->iterations;
  double w = 1.0 / (double) iterations;
  CALCTHREADRESULT *subresult = (CALCTHREADRESULT *) malloc(sizeof(CALCTHREADRESULT));
#ifdef DEBUG
  printf("Dies ist Thread %2d von %2d\n", myrank, size);
#endif
  subresult->sum = 0.0;
  for (i = myrank + 1; i <= iterations; i += size) {
    x = w * ((double) i - 0.5);
    subresult->sum += f(x);
  }
  return subresult;
}


int main(int argc, char *argv[])
{
  int i;
  int rc;
  int numThreads = DEFAULT_NUMTHREADS;
  int iterations = DEFAULT_ITERATIONS;
  double sum, pi;
  pthread_t *tid = (pthread_t *) malloc(numThreads * sizeof(pthread_t));
  CALCTHREADPARAM *params = (CALCTHREADPARAM *) malloc(numThreads * sizeof(CALCTHREADPARAM));
  CALCTHREADRESULT subresult;
  CALCTHREADRESULT *subresultp = &subresult;
  
  /* Threads starten */
  for (i = 0; i < numThreads; i++) {
    params[i].myrank = i;
    params[i].size = numThreads;
    params[i].iterations = iterations;
    rc = pthread_create(&tid[i], NULL, calcthread, &params[i]);
    if (rc != 0)
      err_abort(rc, "pthread_create() fehlgeschlagen");
  }

  /* Ergebnisse der Threads summieren */
  sum = 0.0;
  for (i = 0; i < numThreads; ++i) {
    rc = pthread_join(tid[i], (void *) &subresultp);
    if (rc != 0)
      err_abort(rc, "pthread_join() fehlgeschlagen");
    sum += subresultp->sum;
  }
  pi = 1.0 / (double) iterations * sum;

  free((void *) params);
  free((void *) tid);

  printf("Ergebnis nach %d Iterationen, aufgeteilt auf %d Threads:\n",
	 iterations, numThreads);
  printf("pi = %.13lf (Fehler: %.13lf)\n", pi, pi - PI);

  return 0;
}
