/* $Id: pi2.c 930 2006-07-19 08:13:47Z olau $ */

#include <stdio.h>
#include <pthread.h>
#include <math.h>

#ifdef WIN32
#include <windows.h>
#else
#include <malloc.h>
/* posix_memalign() importieren */
#define __USE_XOPEN2K
#include <stdlib.h>
#endif

#include "../globaldefs.h"
#include "../helper.h"

#define DEFAULT_NUMTHREADS   2


typedef struct _calcthreadparam
{
  CACHE_ALIGN int myrank;
  int size;
  int iterations;
} CALCTHREADPARAM;

typedef struct _calcthreadresult
{
  CACHE_ALIGN volatile double sum;
} CALCTHREADRESULT;

static CALCTHREADRESULT *subresult;


void *calcthread(void *params)
{
  int i;
  double x;
  double sum = 0.0;
  int myrank = ((CALCTHREADPARAM *) params)->myrank;
  int size = ((CALCTHREADPARAM *) params)->size;
  int iterations = ((CALCTHREADPARAM *) params)->iterations;
  double w = 1.0 / (double) iterations;
#ifdef DEBUG
  printf("Dies ist Thread %2d von %2d\n", myrank, size);
#endif
  for (i = myrank + 1; i <= iterations; i += size) {
    x = w * ((double)i - 0.5);
    sum += f(x);
  }
  subresult[myrank].sum = sum;
  pthread_exit(NULL);
  return NULL; /* wird nie ausgefhrt; existiert nur, um Compiler zufriedenstellen */
}


int main(int argc, char *argv[])
{
  int i;
  int rc;
  int numThreads = DEFAULT_NUMTHREADS;
  int iterations = DEFAULT_ITERATIONS;
  double sum, pi;
  pthread_t *tid;
  CALCTHREADPARAM *params;

  sum = 0.0;
  tid = (pthread_t *) malloc(numThreads * sizeof(pthread_t));
#ifdef WIN32
  params = (CALCTHREADPARAM *) _aligned_malloc(numThreads * sizeof(CALCTHREADPARAM), CACHE_LINE_SIZE);
  subresult = (CALCTHREADRESULT *) _aligned_malloc(numThreads * sizeof(CALCTHREADRESULT), CACHE_LINE_SIZE);
#else
  posix_memalign((void *) &params, CACHE_LINE_SIZE, numThreads * sizeof(CALCTHREADPARAM));
  posix_memalign((void *) &subresult, CACHE_LINE_SIZE, numThreads * sizeof(CALCTHREADRESULT));
#endif

  /* Threads starten */
  for (i = 0; i < numThreads; i++) {
    params[i].myrank = i;
    params[i].size = numThreads;
    params[i].iterations = iterations;
    pthread_create(&tid[i], NULL, calcthread, (void *) &params[i]);
  }

  /* Ergebnisse der Threads einsammeln */
  for (i = 0; i < numThreads; i++) {
    rc = pthread_join(tid[i], 0);
    if (rc != 0)
      err_abort(rc, "pthread_join() fehlgeschlagen");
    sum += subresult[i].sum;
  }
  pi = 1.0 / (double) iterations * sum;

#ifdef WIN32
  _aligned_free(subresult);
  _aligned_free(params);
#else
  free(subresult);
  free(params);
#endif
  free(tid);

  printf("Ergebnis nach %d Iterationen, aufgeteilt auf %d Threads:\n",
	 iterations, numThreads);
  printf("pi = %.13lf (Fehler: %.13lf)\n", pi, pi - PI);

  return 0;
}
