/* $Id: signaling.c 882 2006-07-09 14:29:28Z olau $ */

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include "../helper.h"

#ifdef WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif

typedef struct _wait_t {
  pthread_mutex_t mutex;
  pthread_cond_t  cond;
} wait_t;

static wait_t wait =
  { PTHREAD_MUTEX_INITIALIZER, PTHREAD_COND_INITIALIZER };


void *aThread(void *params)
{
  int rc;
  printf("Thread A wartet 2 Sekunden ...\n");
#ifdef WIN32
  Sleep(2000);
#else
  sleep(2);
#endif

  printf("Thread A wartet auf Thread B ...\n");
  rc = pthread_mutex_lock(&wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_mutex_lock() fehlgeschlagen");
  rc = pthread_cond_wait(&wait.cond, &wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_cond_wait() fehlgeschlagen");
  rc = pthread_mutex_unlock(&wait.mutex);
  if (rc != 0)
    err_abort(rc, "pthread_mutex_unlock() fehlgeschlagen");

  printf("Thread A folgt Thread B ...\n");
  return NULL;
}


void *bThread(void *params)
{
  int rc;

  printf("Thread B wartet 4 Sekunden ...\n");
#ifdef WIN32
  Sleep(4000);
#else
  sleep(4);
#endif

  printf("Thread B holt Thread A ab ...\n");
  rc = pthread_cond_signal(&wait.cond);
  if (rc != 0)
    err_abort(rc, "pthread_cond_signal() fehlgeschlagen");

  return NULL;
}


int main(int argc, char *argv[])
{
  pthread_t tidA, tidB;
  int rc;

  /* Threads starten */
  rc = pthread_create(&tidA, NULL, aThread, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_create() fehlgeschlagen");
  rc = pthread_create(&tidB, NULL, bThread, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_create() fehlgeschlagen");

  rc = pthread_join(tidA, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_join() fehlgeschlagen");
  rc = pthread_join(tidB, NULL);
  if (rc != 0)
    err_abort(rc, "pthread_join() fehlgeschlagen");

  pthread_cond_destroy(&wait.cond);
  pthread_mutex_destroy(&wait.mutex);

  printf("\n");
  return 0;
}
