/* $Id: Range.h 1135 2006-09-06 07:53:02Z olau $ */

/* Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>, Heise Zeitschriften Verlag */

#ifndef __RANGE_H_
#define __RANGE_H_

#include "tbb/tbb_stddef.h"

struct MyRange {
  bool empty() const;
  bool is_divisible();
  MyRange(MyRange& r, tbb::split);
};

class TrivialIntegerRange {
  int lower;
  int upper;
  bool empty() const { return lower == upper; }
  bool is_divisible() const { return upper > lower + 1; }
  TrivialIntegerRange(TrivialIntegerRange& r, split) {
    int m = (r.lower + r.upper) / 2;
    lower = m;
    upper = r.upper;
    r.upper = m;
  }
};

#endif /* __RANGE_H_ */
