Imports System.Windows.Forms

<ComClass(WebFunktionen.ClassId, WebFunktionen.InterfaceId, WebFunktionen.EventsId)> _
Public Class WebFunktionen

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class 
    ' and its COM interfaces. If you change them, existing 
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "2cce694e-071e-4e98-99da-458c7758f332"
    Public Const InterfaceId As String = "92e93367-66d6-44bc-bd7d-17215fe7f5e9"
    Public Const EventsId As String = "f8c6e0d0-4bd0-4464-b637-95ed8785e90a"
#End Region

    'Standard-Konstruktor fr COM-Klasse
    Public Sub New()
        MyBase.New()
    End Sub

    '**************************************************************
    'Netzwerk-Infos
    '**************************************************************

    Public Function IstNetzwerkVorhanden() As Boolean
        'Folgendes versuchen:
        Try
            'Ergebnis von IsAvailable-Methode zurckgeben
            Return My.Computer.Network.IsAvailable

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... False zurckgeben
            Return False
        End Try
    End Function

    Public Function IstComputerOnline(ByVal Bezeichner As String) As Boolean
        'Folgendes versuchen:
        Try
            'Computer oder Host anpingen und Ergebnis zurckgeben
            Return My.Computer.Network.Ping(Bezeichner)

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... False zurckgeben
            Return False
        End Try
    End Function

    '**************************************************************
    'Down- und Upload von Dateien
    '**************************************************************

    Public Function DateiDownload(ByVal QuellURL As String, ByVal ZielPfadname As String, Optional ByVal Benutzername As String = "", Optional ByVal Kennwort As String = "") As Boolean
        Dim blnErgebnis As Boolean = False

        'Folgendes versuchen:
        Try
            'Datei von Quell-URL herunterladen und speichern
            My.Computer.Network.DownloadFile(QuellURL, ZielPfadname, Benutzername, Kennwort, False, 20000, True)
            'Wenn Datei jetzt existiert, dann...
            If My.Computer.FileSystem.FileExists(ZielPfadname) = True Then
                '... Ergebnis True merken
                blnErgebnis = True

                'Wenn Datei NICHT existiert, dann...
            Else
                '... Ergebnis False merken
                blnErgebnis = False
            End If

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... Ergebnis False merken
            blnErgebnis = False
        End Try

        'Ergebnis zurckgeben
        Return blnErgebnis
    End Function

    Public Function DateiUpload(ByVal QuellPfadname As String, ByVal ZielURL As String, Optional ByVal Benutzername As String = "", Optional ByVal Kennwort As String = "") As Boolean
        Dim blnErgebnis As Boolean = False

        'Folgendes versuchen:
        Try
            'Datei auf Ziel-URL heraufladen
            My.Computer.Network.UploadFile(QuellPfadname, ZielURL, Benutzername, Kennwort, False, 20000)
            'Wenn dabei kein Fehler auftritt, dann Ergebnis True merken
            blnErgebnis = True

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... Ergebnis False merken
            blnErgebnis = False
        End Try

        'Ergebnis zurckgeben
        Return blnErgebnis
    End Function

    '**************************************************************
    'Google via Web-Service abfragen
    '**************************************************************

    Public Function GoogleAbfrage(ByVal Suchtext As String, ByVal Lizenzschlssel As String) As String
        Dim intMaxFundstellen As Integer = 10
        Dim intStartIndex As Integer = 0
        Dim strTemp As String = ""

        'Google-Suchobjekt anlegen
        Dim gsvAbfrage As New com.google.api.GoogleSearchService

        'Folgendes versuchen:
        Try
            'Suchfunktion aufrufen, Ergebnis in 'gssResult' entgegennehmen
            Dim gssResult As com.google.api.GoogleSearchResult = gsvAbfrage.doGoogleSearch(Lizenzschlssel, Suchtext, intStartIndex, intMaxFundstellen, False, "", False, "", "", "")
            'Anzahl der Fundstellen ermitteln
            Dim intAnzahlFundstellen As Integer = gssResult.estimatedTotalResultsCount

            'Wenn Fundstellen vorhanden, dann...
            If intAnzahlFundstellen > 0 Then
                strTemp = strTemp & "Fundstellen 1-10 von " & CStr(intAnzahlFundstellen) & ":" & vbCr & vbCr

                'Folgendes versuchen:
                Try
                    'Alle Fundstellen durchlaufen
                    For i As Integer = 0 To intAnzahlFundstellen
                        'Titel und URL der jeweiligen Fundstelle hinzufgen
                        strTemp = strTemp & gssResult.resultElements(i).title & vbCr & gssResult.resultElements(i).URL & vbCr & vbCr
                    Next

                    'Im Fall eines Fehlers...
                Catch ex As Exception
                    '... nichts tun
                End Try
            End If

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... Rckgabe-String lschen
            strTemp = ""
        End Try

        'Rckgabe-String retournieren
        Return strTemp
    End Function

End Class


