#!/usr/bin/perl -w
#
# $Id: hash.pl 1211 2006-10-16 16:06:27Z olau $
# 
# Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
#                    Heise Zeitschriften Verlag.
# Alle Rechte vorbehalten.

use strict;

my $file1 = shift;
my $file2 = shift;
my $cross = shift;

open(CROSS, ">$cross") or die "Cannot open file '$cross': $!\n";

my %lex1;
my %lex2;

open(IN, "<$file1") or die "Cannot open file '$file1': $!\n";

my $num_lines1 = 0;
my $num_words1 = 0;

while (<IN>) {
	my @words = split /\W/;
	foreach my $w (@words) {
		$lex1{$w} = 1;
		++$num_words1;
	}
	++$num_lines1;
}

print "$num_lines1 lines\n";
print "$num_words1 words\n";

close(IN);


open(IN, "<$file2") or die "Cannot open file '$file2': $!\n";

my $num_lines2 = 0;
my $num_words2 = 0;

while (<IN>) {
	my @words = split /\W/;
	foreach my $w (@words) {
		$lex2{$w} = 1;
		++$num_words2;
	}
	++$num_lines2;
}

print "$num_lines2 lines\n";
print "$num_words2 words\n";

close(IN);

my $num_crosswords = 0;

foreach my $k (keys %lex1) {
	if (defined($lex2{$k})) {
		print CROSS	"$k\n";
		++$num_crosswords;
	}
}

close CROSS;

print "$num_crosswords words used in both files\n";


0;
