/* $Id: main.cpp 1211 2006-10-16 16:06:27Z olau $ */

/* 
   Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/

#include "../timer/timer.h"

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

#include <QHash>
#include <QString>

#include "../testdata/testdata.h"
const char *file_cross = "../../diff-qhash.txt";

typedef QHash<QString, flag_t> Lexicon;

Lexicon lex;


bool lookup(const char *w, bool contained)
{
  bool found = (lex[w].contained == true);
  bool ok = (found == contained);
  cout << w << ": "
    << (found? "GEFUNDEN" : "nicht gefunden")
    << " -> "
    << (ok? "ok" : "FEHLER")
    << endl;
  return ok;
}


int main(int argc, char *argv[])
{
  LONGLONG t;

  std::vector<char *>  wordlist;

  fstream f1;
  fstream f2;

  f1.open(file1, ios::in);
  if (f1.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file1 << "'.\n";
    exit(1);
  }

  cout << "Indexieren der Datei '" << file1 << "' ...";
  readfile(wordlist, f1);
  START();
  for (size_t i = 0; i < wordlist.size(); ++i)
    lex[wordlist[i]].contained = true;
  STOP(t);
  f1.close();
  wordlist.clear();

  cout << endl << "Dauer: " 
    << (1000ULL*t/T_RESULT_RESOLUTION) << " ms" 
    << endl;


#if DO_TESTS
  bool ok = true;
  ok = ok && lookup("Pride", true);
  ok = ok && lookup("Prejudice", true);
  ok = ok && lookup("Jane", true);
  ok = ok && lookup("Tarzan", false);
  ok = ok && lookup("single", true);
  ok = ok && lookup("universally", true);
  ok = ok && lookup("goodie", false);
  ok = ok && lookup("a", true);
  ok = ok && lookup("caprice", true);
  ok = ok && lookup("chapter", false);
  ok = ok && lookup("Chapter", true);
  ok = ok && lookup("ductility", true);
  ok = ok && lookup("ala", false);
  cout << endl 
    << (ok? "Alle Tests bestanden." : "Einige Tests sind fehlgeschlagen.")
    << endl << endl;
#endif /* DO_TESTS */

  cout << "Schnittmenge zur Datei '" << file2 << "' berechnen ...";

  f2.open(file2, ios::in);
  if (f2.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file2 << "'.\n";
    exit(1);
  }

#if WRITE_CROSS
  fstream cross;
  cross.open(file_cross, ios::out);
  if (cross.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file_cross << "'.\n";
    exit(1);
  }
#endif

  readfile(wordlist, f2);

  START();
  int num_words = 0;
  for (size_t i = 0; i < wordlist.size(); ++i)
  {
    char *word = wordlist[i];
    if (lex[word].contained)
    {
      if (!lex[word].visited)
      {
#if WRITE_CROSS
        cross << word << endl;
#endif
        ++num_words;
        lex[word].visited = true;
      }
    }
  }
  STOP(t);

  f2.close();
#if WRITE_CROSS
  cross.close();
#endif

  cout << endl << "Dauer: " 
    << (1000ULL*t/T_RESULT_RESOLUTION) << " ms" 
    << endl;

  cout << endl << endl <<
    "Anzahl der in beiden Dateien vorhandenen Wrter: " 
    << num_words << endl;

  return 0;
}
