/* $Id: testdata.cpp 1211 2006-10-16 16:06:27Z olau $ */

/* 
   Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/

#include "testdata.h"

const char *file1 = "../testdata/pandp12.txt";
const char *file2 = "../testdata/sense11.txt";
//const char *file1 = "../testdata/ct1990.txt";
//const char *file2 = "../testdata/ct1991.txt";

using namespace std;

/// Das nchste Wort aus dem Eingabestrom einlesen.
int readword(char *word, istream &input)
{
  int i = 0;
  if (!input.eof())
  {
    char ch;
    input.read(&ch, sizeof(ch));
    while (is_char((int) ch) && i < MAX_WORD_LENGTH)
    {
      word[i++] = ch;
      input.read(&ch, sizeof(ch));
    }
  }
  word[i] = 0;
  return i;
}


/// Textdatei wortweise in Array speichern.
void readfile(std::vector<char *> &wordlist, istream &input)
{
  char word[MAX_WORD_LENGTH];
  while (!input.eof())
  {
    char ch;
    input.read(&ch, sizeof(ch));
    int i = 0;
    // nchstes Wort einlesen
    while (is_char((int) ch) && i < MAX_WORD_LENGTH)
    {
      word[i++] = ch;
      input.read(&ch, sizeof(ch));
    }
    // Wort zur Wortliste hinzufgen
    if (i > 0) 
    {
      word[i] = 0;
      char *w = new char[i + 1];
      strcpy(w, word);
      wordlist.push_back(w);
    }
  }
}
