/* $Id: testdata.h 1213 2006-10-17 05:53:09Z olau $ */

/* 
   Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/

#ifndef __TESTDATA_H_
#define __TESTDATA_H_

#include <iostream>
#include <vector>
#include <cstring>

#ifdef __cplusplus
extern "C" {
#endif 

/// Maximal erlaubte Wortlnge.
static const int MAX_WORD_LENGTH = 100;

#define DO_TESTS         0
#define WRITE_CROSS      0

extern const char *file1;
extern const char *file2;

struct _flags_t_
{
  bool contained;
  bool visited;
  /*int frequency;*/
  _flags_t_() : contained(false), visited(false)/*, frequency(0)*/ {};
};

typedef struct _flags_t_ flag_t;

/// Ermitteln, ob bergebenes Zeichen ein Buchstabe/eine Ziffer ist.
inline bool is_char(int x)
{
  return ((x > 64 && x < 91)
    || (x > 47 && x < 58)
    || (x > 96 && x < 123)
    || (x > 128 && x < 255));
}

extern int readword(char *word, std::istream &input);
extern void readfile(std::vector<char *> &wordlist, std::istream &input);

#ifdef __cplusplus
}
#endif

#endif /* __TESTDATA_H_ */
