import java.io.Console;
import java.security.MessageDigest;

public class ConsoleDemo {
	public static void main(String... args) throws Exception {
		String testString = "Deutsche Sonderzeichen: ";
		// This prints garbage ...
		System.out.println("via System.out: " + testString);
		Console console = System.console();
		if (console == null) {
			System.err.println("No console found.");
		} else {
			// This prints the expected test string
			console.writer().println("via System.console(): " + testString);
			// Get password via new method ...
			char[] password = console.readPassword("Password: ", null);
			// Calculate MD5 ...
			MessageDigest md = MessageDigest.getInstance("MD5");
			String passwordString = new String(password);
			byte[] passwordBytes = passwordString.getBytes("UTF-8");
			md.update(passwordBytes);
			byte[] md5Bytes = md.digest();
			// Print MD5 ...
			StringBuilder sb = new StringBuilder();
			for (byte b : md5Bytes) {
				sb.append(Integer.toHexString(0xFF & b));
			}
			console.writer().println("Password MD5: " + sb);
		}
	}
}
