import static javax.xml.stream.XMLStreamConstants.*;

import javax.xml.stream.*;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.File;
/**
 * @author Michael Tamm
 */
public class StaxDemo {
	public static void main(String... args) throws Exception {
		InputStream in = new FileInputStream("build.xml");
		try {
			XMLInputFactory factory = XMLInputFactory.newInstance();
			XMLStreamReader reader = factory.createXMLStreamReader(in);
			while (reader.hasNext()) {
				int event = reader.next();
				if (event == START_ELEMENT && 
						reader.getLocalName().equals("target")) {
					System.out.println(reader.getAttributeValue(null, "name"));
				}
			}
		} finally {
		    in.close();
		}					
	}
}
