/*	Projekt UacHelper
	SpeedProject
	Copyright  1995 - 2006. Alle Rechte vorbehalten.

	Datei:		UacHelper.cpp
	Autor:		Sven Ritter
	Datum:		09.11.2006 - 11:29:45


	UEBERBLICK
	==========
	Quelltextdatei fuer die Implementation von DllMain.
*/


#include "StdAfx.h"
#include "UacHelper.rh"
#include <initguid.h>
#include "UacHelper.h"
#include "dlldatax.h"

//
#include "UacWorker.h"

// IIDs
#ifdef WIN64
#include "UacHelper64_i.c"
#else
#include "UacHelper32_i.c"
#endif


// ****************************************************************************
// ******                  Konstanten und globale Variablen              ******
// ****************************************************************************
CComModule _Module;


// ****************************************************************************
// ******                            Objektliste                         ******
// ****************************************************************************
BEGIN_OBJECT_MAP(ObjectMap)
	OBJECT_ENTRY(CLSID_UacWorker, CUacWorker)
END_OBJECT_MAP()


// ****************************************************************************
// ******                     Implementation zu DllMain                  ******
// ****************************************************************************
extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Weiterleiten an Proxy
    if (!PrxDllMain(hInstance, dwReason, lpReserved))
        return FALSE;

	// Dll geladen
    if (DLL_PROCESS_ATTACH == dwReason)
    {
		// Initialisierung
		_Module.Init(ObjectMap, hInstance, &LIBID_UACHELPERLib);

		// DLL_THREAD_ATTACH/DLL_THREAD_DETACH sind nicht gewuenscht
        DisableThreadLibraryCalls(hInstance);
    }

	// Dll entladen
    else if (DLL_PROCESS_DETACH == dwReason)
	{
        _Module.Term();
	}

	// Alles ok
    return TRUE;
}

// ****************************************************************************
// ******                 Implementation zu DllCanUnloadNow              ******
// ****************************************************************************
STDAPI DllCanUnloadNow()
{
	// Weiterleiten an Proxy
    if (PrxDllCanUnloadNow() != S_OK)
        return S_FALSE;

	// Entladen, wenn Dll nicht mehr gesperrt ist
    return (0 == _Module.GetLockCount()) ? S_OK : S_FALSE;
}


// ****************************************************************************
// ******                Implementation zu DllGetClassObject             ******
// ****************************************************************************
STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	// Weiterleiten an Proxy
    if (PrxDllGetClassObject(rclsid, riid, ppv) == S_OK)
        return S_OK;

	// Klasse erstellen
    return _Module.GetClassObject(rclsid, riid, ppv);
}


// ****************************************************************************
// ******                Implementation zu DllRegisterServer             ******
// ****************************************************************************
STDAPI DllRegisterServer()
{
	// Weiterleiten an Proxy
    HRESULT hRes = PrxDllRegisterServer();
    if (FAILED(hRes))
        return hRes;

    // Objekte registrieren
    return _Module.RegisterServer(FALSE);
}


// ****************************************************************************
// ******               Implementation zu DllUnregisterServer            ******
// ****************************************************************************
STDAPI DllUnregisterServer()
{
	// Weiterleiten an Proxy
    PrxDllUnregisterServer();

	// Objekte aus Registration entfernen
    return _Module.UnregisterServer(FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CUacHelper
