#if !defined(__UacHelperInterfaces_h)
#define __UacHelperInterfaces_h

/*	Projekt UacHelper
	SpeedProject
	Copyright  1995 - 2006. Alle Rechte vorbehalten.

	Datei:		UacHelperInterfaces.h
	Autor:		Sven Ritter
	Datum:		09.11.2006 - 12:16:17


	UEBERBLICK
	==========
	Definition der COM-Interfaces und GUIDs.
*/


// ****************************************************************************
// ******                Header nur einmal pro Build includen            ******
// ****************************************************************************
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


// ****************************************************************************
// ******                    Externe Klassendefinitionen                 ******
// ****************************************************************************
#ifndef _INC_COMDEF
#include <comdef.h>
#endif


// ****************************************************************************
// ******                  Konstanten und globale Variablen              ******
// ****************************************************************************


// ****************************************************************************
// ******                   Definition zu LUA_DEFINE_GUID                ******
// ****************************************************************************
#define LUA_DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
        EXTERN_C const GUID DECLSPEC_SELECTANY name = { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }


// ****************************************************************************
// ******                               CLSIDs                           ******
// ****************************************************************************
LUA_DEFINE_GUID(CLSID_UacWorker, 0xF0B4418C, 0x9B8D, 0x4C67, 0x8B, 0x70, 0xD5, 0x02, 0x77, 0xED, 0x22, 0x50);


// ****************************************************************************
// ******                                IIDs                            ******
// ****************************************************************************
LUA_DEFINE_GUID(IID_IUacWorker, 0x5A548F25, 0xDDDE, 0x4236, 0xBF, 0x83, 0x74, 0x4B, 0xC5, 0xDD, 0xFD, 0x57);


// ****************************************************************************
// ******                      Definition zu IUacWorker                  ******
// ****************************************************************************
MIDL_INTERFACE("5A548F25-DDDE-4236-BF83-744BC5DDFD57")
IUacWorker : public IUnknown {

	virtual STDMETHODIMP	CheckElevation		(UINT* pElevationType) = 0;
	virtual STDMETHODIMP	CheckFileAccess		() = 0;
	virtual STDMETHODIMP	CheckRegistryAccess	() = 0;
};


// ****************************************************************************
// ******                      SmartPtr fuer Interfaces                  ******
// ****************************************************************************
_COM_SMARTPTR_TYPEDEF(IUacWorker, __uuidof(IUacWorker));


// ****************************************************************************
// ******                        INLINE-Definitionen                     ******
// ****************************************************************************


#endif										// __UacHelperInterfaces_h


// ****************************************************************************
// ******                            END OF FILE                         ******
// ****************************************************************************