/*
============================================================================
 Name        : HelloworldAppUi.h
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
 Description : Declares UI class for application.
============================================================================
*/

#ifndef HELLOWORLDAPPUI_H
#define HELLOWORLDAPPUI_H

// INCLUDES
#include <aknappui.h>

// FORWARD DECLARATIONS
class CHelloworldContainer;
class CFilepusher;

// CLASS DECLARATION

/**
* Application UI class.
* Provides support for the following features:
* - EIKON control architecture
*
*/

class CHelloworldAppUi : public CAknAppUi
    {
    public: // // Constructors and destructor

        /**
        * EPOC default constructor.
        */
        void ConstructL();

        /**
        * Destructor.
        */
        ~CHelloworldAppUi();

    public: // New functions
        void PushFileL();

    public: // Functions from base classes

    private:
        // From MEikMenuObserver
        void DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane);

    private:
        /**
        * From CEikAppUi, takes care of command handling.
        * @param aCommand command to be handled
        */
        void HandleCommandL(TInt aCommand);

        /**
        * From CEikAppUi, handles key events.
        * @param aKeyEvent Event to handled.
        * @param aType Type of the key event.
        * @return Response code (EKeyWasConsumed, EKeyWasNotConsumed).
        */
        virtual TKeyResponse HandleKeyEventL(
            const TKeyEvent& aKeyEvent,TEventCode aType);

    private: //Data
        CHelloworldContainer* iAppContainer;
        CFilepusher *iFilepusher;
    };

#endif


