// $Id: ColorScheme.h 276 2007-04-30 09:30:44Z olau $

#ifndef __COLORSCHEME_H_
#define __COLORSCHEME_H_



class ColorScheme {
public:
    static const int maxColors = 16*1024*1024;
    enum Name {
        PastelGreen,
        GreenTomato,
        VioletTriade,
        Tetrade90,
        Rainbow,
    };   	
    ColorScheme(int which = Rainbow);
    void choose(int which);
    const COLORREF color(int i) const { return table[i % numColors]; }
    int NumColors(void) { return numColors; }

private:
    static Mutex mutex;
    static bool initialized;
    int numColors;
    static COLORREF pastelGreens[4];
    static COLORREF greenTomato[8];
    static COLORREF violetTriade[12];
    static COLORREF tetrade90[16];
    static COLORREF rainbow[512];
    COLORREF *table;
    COLORREF rgbFromWaveLength(double wave);
};


const int DefaultScheme = ColorScheme::Rainbow;

#endif // __COLORSCHEME_H_
