// $Id: ParallelLog.cpp 249 2007-04-26 08:48:05Z olau $

#include "stdafx.h"

static int __cdecl compare(const void *_a, const void *_b)
{
    const LogEntry *a = (const LogEntry *) _a;
    const LogEntry *b = (const LogEntry *) _b;
    if (a->timestamp < b->timestamp)
        return -1;
    else if (a->timestamp < b->timestamp)
        return 1;
    return 0;
}


ParallelLog::ParallelLog(LONG size) : idx(-1), maxIdx(size)
{
    buf = (LogEntry *) VirtualAlloc(NULL, sizeof(LogEntry) * maxIdx, MEM_COMMIT, PAGE_READWRITE);
    ZeroMemory(buf, sizeof(LogEntry) * maxIdx);
}


ParallelLog::~ParallelLog()
{
    VirtualFree(buf, 0, MEM_RELEASE);
    buf = NULL;
}


void ParallelLog::addEntry(const char *msg)
{
    LONG i = InterlockedIncrement(&idx) % maxIdx;
    buf[i].timestamp = time(NULL);
    buf[i].threadId = GetCurrentThreadId();
    buf[i].msg = msg;
}


void ParallelLog::reset(void)
{
    InterlockedExchange(&idx, -1);
}


void ParallelLog::print(void)
{
    if (idx <= 0)
        return;
    int size = idx % maxIdx;
    qsort(&buf, idx % maxIdx, sizeof(LogEntry), compare);
    printf("thread id \t timestamp \t event\n");
    printf("--------- \t --------- \t --------------------------\n");
    for (int i = 0; i < size; ++i)
    {
        printf("0x%8.8x\t 0x%8.8x\t %s\n",
            buf[i].threadId, buf[i].timestamp, buf[i].msg);
    }
}
