// $Id: Thread.h 302 2007-05-03 15:20:29Z olau $

#pragma once

#ifdef _DEBUG
#define NOP() __asm nop
#else
#define NOP()
#endif //_DEBUG

class Thread;

typedef unsigned int THREADRESULT;
typedef unsigned int THREADID;

extern void SetThreadName(DWORD id, LPCSTR szThreadName);


///////////////////////////////////////////////////////////////////
// class ThreadPrivate
///////////////////////////////////////////////////////////////////

class ThreadPrivate
{
public:
    ThreadPrivate() {}
    static THREADRESULT CALLBACK start(LPVOID);
    THREADRESULT result;
};


///////////////////////////////////////////////////////////////////
// class Thread
///////////////////////////////////////////////////////////////////

class Thread
{
public:
    enum Priority
    {
        IdlePriority = THREAD_PRIORITY_IDLE,
        LowestPriority = THREAD_PRIORITY_LOWEST,
        LowPriority = THREAD_PRIORITY_BELOW_NORMAL,
        NormalPriority = THREAD_PRIORITY_NORMAL,
        HighPriority = THREAD_PRIORITY_ABOVE_NORMAL,
        HighestPriority = THREAD_PRIORITY_HIGHEST,
        TimeCriticalPriority = THREAD_PRIORITY_TIME_CRITICAL,
        InheritPriority = 0x7fffffff,
    };

    enum ErrorCode
    {
        NoError = 0,
        SetEventFailed,
        SetThreadAffinityMaskFailed,
        SetThreadPriorityFailed,
        SetThreadPriorityBoostFailed,
        CreateThreadFailed,
        SuspendThreadFailed,
        ResumeThreadFailed,
        InvalidHandle,
    };

    explicit Thread(Priority priority = InheritPriority);
    virtual ~Thread();

    int allowBoost(void);
    int disallowBoost(void);
    int start(void);
    int suspend(void);
    int wait(void);
    void yield(void);

    int setAffinityMask(DWORD_PTR mask);
    int setPriority(Priority);
    Priority priority() const { return m_priority; }
    bool isRunning() const { return m_isRunning; }
    THREADID id() { return m_id; }
    HANDLE handle() { return m_handle; }
    THREADRESULT result() { return m_result; }

#ifdef _DEBUG
    void setName(LPCSTR);
#endif

protected:
    virtual THREADRESULT run() = 0;
    friend class ThreadPrivate;

private:
    ThreadPrivate thread;
    HANDLE m_handle;
    THREADID m_id;
    Priority m_priority;
    DWORD_PTR m_affinityMask;
    bool m_isRunning;
    THREADRESULT m_result;
};
