///////////////////////////////////////////////////////////////////////////////
// XTIB.H  Version 1.2
//
// Author:  Hans Dietrich
//          hdietrich2@hotmail.com
//
// Original TIB.H file from Microsoft Systems Journal "Under the Hood",
// May 1996, by Matt Pietrek
//
// Portions copied from Microsoft Systems Journal "Bugslayer Column",
// Feb 2000, by John Robbins
//
// This software is released into the public domain.
// You are free to use it in any way you like.
//
// This software is provided "as is" with no expressed
// or implied warranty.  I accept no liability for any
// damage or loss of business that this software may cause.
//
///////////////////////////////////////////////////////////////////////////////

#pragma once

#include "stdafx.h"

// Call SetThreadName(), and then paste this expression into the watch window:
//    (char*)(DW(@TIB+0x14))

#pragma pack(1)

typedef struct tagXTIB
{
    PEXCEPTION_REGISTRATION_RECORD pvExcept; // 00h Head of exception record list
    PVOID	pvStackUserTop; 			// 04h Top of user stack
    PVOID	pvStackUserBase;			// 08h Base of user stack

    union								// 0Ch (NT/Win95 differences)
    {
        struct							// Win95 fields
        {
            WORD	pvTDB;				// 0Ch TDB
            WORD	pvThunkSS;			// 0Eh SS selector used for thunking to 16 bits
            DWORD	unknown1;			// 10h
        } WIN95;

        struct	// WinNT fields
        {
            PVOID SubSystemTib; 		// 0Ch
            ULONG FiberData;			// 10h
        } WINNT;
    } TIB_UNION1;

    PVOID	pvArbitrary;				// 14h Available for application use
    struct _tib *ptibSelf;				// 18h Linear address of TIB structure

    union								// 1Ch (NT/Win95 differences)
    {
        struct	// Win95 fields
        {
            WORD	TIBFlags;			// 1Ch
            WORD	Win16MutexCount;	// 1Eh
            DWORD	DebugContext;		// 20h
            DWORD	pCurrentPriority;	// 24h
            DWORD	pvQueue;			// 28h Message Queue selector
        } WIN95;

        struct	// WinNT fields
        {
            DWORD unknown1; 			// 1Ch
            DWORD processID;			// 20h
            DWORD threadID; 			// 24h
            DWORD unknown2; 			// 28h
        } WINNT;
    } TIB_UNION2;

    PVOID*	pvTLSArray; 				// 2Ch Thread Local Storage array

    union								// 30h (NT/Win95 differences)
    {
        struct	// Win95 fields
        {
            PVOID*	pProcess;			// 30h Pointer to owning process database
        } WIN95;
    } TIB_UNION3;

} XTIB;

extern tagXTIB * GetTIB();
extern BOOL SetThreadNameViaTIB(LPCTSTR szName);
extern LPCTSTR GetThreadNameViaTIB();
#pragma pack()
