// $Id: MandelbrotSet.h 274 2007-04-30 08:21:58Z olau $

#ifndef __MANDELBROTSET_H_
#define __MANDELBROTSET_H_

#include "stdafx.h"

class ColorScheme;


class MandelbrotSet
{
private:
    __declspec(align(16)) double threshold;
    __declspec(align(16)) int maxIterations;
    int algorithm;
    ColorScheme *scheme;
    static const int MandelbrotDefaultDepth = 2000;

    __int64 renderLine_C(double re0, double re1, double im, COLORREF *scanLine, double scale);
    __int64 renderLine_SSE2(double re0, double re1, double im, COLORREF *scanLine, double scale);

public:
    enum Algorithm {
        C,
        SSE2,
    };

    MandelbrotSet();
    void setThreshold(double threshold) { this->threshold = threshold; }
    void setMaxIterations(int maxIterations) { this->maxIterations = maxIterations; }
    void setScheme(ColorScheme *scheme) { this->scheme = scheme; }
    void setAlgorithm(int algorithm) { this->algorithm = algorithm; }
    __int64 render(double reC, double imC, double scale, const BITMAP *bitmap, bool *restart);

};


#endif // __MANDELBROTSET_H_
