// $Id: Thread.cpp 277 2007-04-30 10:31:18Z olau $

#include "stdafx.h"

///////////////////////////////////////////////////////////////////
// class ThreadPrivate
///////////////////////////////////////////////////////////////////

THREADRESULT ThreadPrivate::start(LPVOID data)
{
    Thread *thr = reinterpret_cast<Thread *>(data);
    thr->m_result = thr->run();
    return thr->result();
}


///////////////////////////////////////////////////////////////////
// class Thread
///////////////////////////////////////////////////////////////////

Thread::Thread(Priority priority) : m_isRunning(false), m_result(0)
{
    m_handle = (HANDLE)_beginthreadex(NULL, 0, ThreadPrivate::start, this, CREATE_SUSPENDED, &m_id);

    if (priority != InheritPriority)
    {
        setPriority(priority);
    }

    allowBoost();
}


Thread::~Thread(void)
{
    if (m_isRunning)
    {
        wait();
        m_isRunning = false;
    }
}


int Thread::start(void)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    if (!m_isRunning)
    {
        if (ResumeThread(m_handle) < 0)
        {
            return ResumeThreadFailed;
        }
        m_isRunning = true;
    }

    return NoError;
}


int Thread::suspend(void)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    if (m_isRunning)
    {
        if (SuspendThread(m_handle) < 0)
        {
            return SuspendThreadFailed;
        }
    }
    return NoError;
}


void Thread::yield(void)
{
    SwitchToThread();
}


int Thread::wait(void)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    WaitForSingleObject(m_handle, INFINITE);
    return NoError;
}


int Thread::allowBoost(void)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    if (!SetThreadPriorityBoost(m_handle, FALSE /* sic! */))
    {
        return SetThreadPriorityBoostFailed;
    }
    return NoError;
}


int Thread::disallowBoost(void)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    if (!SetThreadPriorityBoost(m_handle, TRUE /* sic! */))
    {
        return SetThreadPriorityBoostFailed;
    }
    return NoError;
}


int Thread::setPriority(Priority priority)
{
    if (m_handle == NULL)
    {
        return InvalidHandle;
    }

    m_priority = priority;
    if (m_isRunning)
    {
        suspend();
    }
    if (!SetThreadPriority(m_handle, m_priority))
    {
        return SetThreadPriorityFailed;
    }
    return NoError;
}


int Thread::setAffinityMask(DWORD_PTR mask)
{
    m_affinityMask = mask;
    if (m_isRunning)
    {
        suspend();
    }
    if (!SetThreadAffinityMask(m_handle, m_affinityMask))
    {
        return SetThreadAffinityMaskFailed;
    }
    start();
    return NoError;
}


#pragma region SetThreadName
#ifdef _DEBUG

void SetThreadName(DWORD id, LPCSTR szThreadName)
{
    // Microsoft Visual Studio 2003 and 2005 allow 
    // see: http://msdn2.microsoft.com/en-us/library/xcb2z8hs(vs.80).aspx
    const DWORD MS_VC_EXCEPTION = 0x406D1388u;

    struct THREADNAME_INFO
    {
        DWORD dwType; // Must be 0x1000.
        LPCSTR szName; // Pointer to name (in user addr space).
        DWORD dwThreadID; // Thread ID (-1=caller thread).
        DWORD dwFlags; // Reserved for future use, must be zero.
    };

    THREADNAME_INFO info;
    info.dwType = 0x1000;
    info.szName = szThreadName;
    info.dwThreadID = id;
    info.dwFlags = 0;

    __try
    {
        RaiseException(MS_VC_EXCEPTION, 0, sizeof(info) / sizeof(DWORD), (DWORD*) &info);
    }
    __except(EXCEPTION_CONTINUE_EXECUTION)
    {
    }
}

// Usage: SetThreadName (-1, "name of thread");
void Thread::setName(LPCSTR szThreadName)
{
    SetThreadName(m_id, szThreadName);
}
#endif //_DEBUG
#pragma endregion
