Event.observe(window, 'load', init, false);
function init(){
	// ist GoogleGears bereits installiert?
	if (!window.google || !google.gears) {
	  location.href = "http://gears.google.com/?action=install&message="+ encodeURI(AM.please_install_gears_message) +"&return="+document.URL;
	}

	AM.are_we_online();
	AM.show_records();
	AM.init_mode_switcher();
}
AM.please_install_gears_message = 'Bitte installieren Sie zuerst GoogleGears!';


/**
*	Zeigt die Adress-Datensätze auf der Seite an
* @param records Der Parameter records enthält ein Array mit Adress-Datensätzen
* @return String Zurückgegeben wird ein String, der das auszugebende HTML enthält
*/
AM.show_records = function(){
	// hier wird nachher unser Adress-HTML drinstehen
	var record_HTML = '';
	// je nachdem, ob wir im online- oder offline-Modus sind, werden die Datensaetze aus dem statischen online-Javascript oder der Gears SQLite-DB geholt
	if(mode == 'online'){
		records = AM.Data;
	}else{
		records = AM.get_records_from_gears('select * from addresses', null);
	}

	// wir iterieren in einer Schleife durch alle übergebenen Adress-Datensätze und formatieren diese als HTML
	for(var i=0; i<records.length; i++){
		record_HTML += '<div class="address_record" id="record_nr_'+i+'">';
		record_HTML += 		'<h3>'+ records[i].name +' &nbsp;&nbsp;<a href="javascript:void(0);" onclick="AM.delete_record('+i+');"><img src="images/garbage.gif" width="12" height="12" /></h3></a>';
		record_HTML += 		'<div class="cat_tags">Kategorie: '+ records[i].category +' | Tags: '+ records[i].tags +'</div>';
		record_HTML += 		'<div class="details_box">'+ records[i].street +'<br />'+ records[i].zip +' '+ records[i].city +'<br />Tel.: '+ records[i].phone +'<br />Email: '+ records[i].email +'</div>';
		record_HTML += 		'<div class="description_box">'+ records[i].description +'<br /><br /></div>';
		record_HTML += '</div>';
	}
	
	Element.update('records_container', record_HTML);
}


/**
*	Neuen Adress-Datensatz anlegen
* der Datensatz wird - aus Gruenden der Einfachheit - nur als JavaScript-Objekt erstellt, also nicht persistent gespeichert,
* da in dieser Beispiel-Applikation keine Datenbank auf der Server-Seite zum Einsatz kommt
*/
AM.save_new = function(){
	var name_val = $('new_record_name').value;
	var street_val = $('new_record_street').value;
	var zip_val = $('new_record_zip').value;
	var city_val = $('new_record_city').value;
	var email_val = $('new_record_email').value;
	var phone_val = $('new_record_phone').value;
	var tags_val = $('new_record_tags').value;
	var category_val = $('new_record_category').value;
	var description_val = $('new_record_description').value;

	if(mode == 'online'){
		AM.Data.push({
			name: name_val,
			street: street_val,
			zip: zip_val,
			city: city_val,
			email: email_val,
			phone: phone_val,
			tags: tags_val,
			category: category_val,
			description: description_val
		});

		// Daten auf dem Server speichern
		new Ajax.Request('save_online.php',
				{method:'post',
					postBody:'data='+AM.data_to_string()
				});
	}else{
		AM.execute('INSERT INTO addresses (name, category, street, zip, city, phone, email, tags, description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)', [name_val, category_val, street_val, zip_val, city_val, phone_val, email_val, tags_val, description_val]);
	}
	
	// den geoeffneten "Neu anlegen"-Dialog schliessen und die Eingabe-Felder leeren
	Element.hide('new_record');
	$('new_record_name').value = '';
	$('new_record_street').value = '';
	$('new_record_zip').value = '';
	$('new_record_city').value = '';
	$('new_record_email').value = '';
	$('new_record_phone').value = '';
	$('new_record_tags').value = '';
	$('new_record_category').value = '';
	$('new_record_description').value = '';

	// Meldung ausgeben
	Element.update('notice', 'Datensatz wurde erfolgreich gespeichert!');
	Element.show('notice');
	new Effect.Highlight('notice');
	new Effect.Fade('notice', {duration: 2.5});

	// Datensaetze anzeigen
	AM.show_records();
}


/**
*	loescht einen Datensatz
*/
AM.delete_record = function(id){
	if(confirm("Wollen Sie diesen Datensatz wirklich loeschen?")){
		if(mode == 'online'){
			AM.Data.splice(id,1);

			// Daten auf dem Server speichern
			new Ajax.Request('save_online.php',
					{method:'post',
						postBody:'data='+AM.data_to_string(),
						onSuccess:function(r){
							// Interface / Anzeige aktualisieren
							AM.show_records();
						}
					});
		}else{
			var name = AM.Data[id].name;
			AM.execute('DELETE FROM addresses WHERE name = ?', [name]);
			// Interface / Anzeige aktualisieren
			AM.show_records();
		}	
	}	
}

/**
*	Ueberprueft, ob wir im Online-Modus sind
* Existiert eine GoogleGears-SQLite-Datenbank mit Daten in der Tabelle addresses, so sind wir im Offline-Modus - sonst im Online-Modus!
* Erklaerung: Vor jedem Offline-Gehen muss der User den "Offline"-Button betaetigen, der mit GoogleGears eine SQLite-Datenbank anlegt
* Beim Online-Gehen wird diese Tabelle wieder geleert
*/
AM.are_we_online = function(){
	if(typeof db == 'undefined'){
		AM.init_db();
	}
  try {
		var res = AM.execute('select count(*) from addresses', null);
		if(res.field(0) > 0){
			mode = 'offline';
			return false;
		}else{
			mode = 'online';
			return true;
		}
  } catch (e) {
		mode = 'online';
    return true;
  }

}


/**
*	Offline-Modus starten
* Hier wird die Anwendung Offline geschaltet: wir erstellen eine SQLite-Datenbank und speichern die Datensaetze fuer den Offline-Zugriff
* Desweiteren sagen wir der Anwendung/dem Browser, welche URLs offline verfuegbar sind
*/
AM.go_offline = function(){
	// Datenbank anlegen und Standard-Tabelle erstellen
	AM.init_db();
	// Online-Daten (in diesem Bsp: JavaScript-Objekte) in die Datenbank fuellen
	for(var i=0; i<AM.Data.length; i++){
		var d = AM.Data[i];
		AM.execute('INSERT INTO addresses (name, category, street, zip, city, phone, email, tags, description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)', [d.name, d.category, d.street, d.zip, d.city, d.phone, d.email, d.tags, d.description]);
	}

	// den lokalen Server aktivieren - hier vermerkte Dokumente werden lokal zurueckgegeben
  localServer = google.gears.factory.create("beta.localserver","1.0");
  store = localServer.createManagedStore('offline_docs');
	store.manifestUrl = 'manifest.json';
	Element.show('capture_loader');
	store.checkForUpdate();

  var timerId = window.setInterval(function() {
		// momentan wird leider noch kein Event ausgeloest, wenn der Update-Vorgang beendet ist
		// d.h. dass dies derzeit laufend ueber ein JS-Intervall geprueft werden muss
    if (store.currentVersion) {
      window.clearInterval(timerId);
			Element.hide('capture_loader');
    }
  }, 500);

	// Modus-wechseln-Button anpassen
	mode = 'offline';
	AM.init_mode_switcher();
}


/**
* Zurueck in den Online-Modus
* Wir loeschen alle Daten aus der Datenbank - bei leerer Datenbank weiss unsere Applikation, dass sie im Online-Modus sein muss
*/
AM.go_online = function(){
	// Offline-Daten in die Online-Anwendung uebertragen -- Daten auf dem Server speichern
	new Ajax.Request('save_online.php',
			{method:'post',
				postBody:'data='+AM.data_to_string()
			});

	// alle Daten aus der Offline-Datenbank loeschen
	AM.clear_db();
	delete db;
	
	// den lokalen Server deaktivieren - Dokumente wieder ueber das WWW anfordern
  if(typeof localServer != 'undefined'){
		localServer.removeManagedStore('offline_docs');
		delete localServer;
	}

	// Modus-wechseln-Button anpassen
	mode = 'online';
	AM.init_mode_switcher();
}


/**
*	Datenbank initialisieren - Tabelle(n) erstellen
* die Datenbank ist dann als globale Variable "db" verfuegbar
*/
AM.init_db = function(){
	db = AM.create_db();
  AM.execute('create table if not exists addresses (' +
				             'id integer not null primary key autoincrement,' +
				             'name varchar(255),' +
				             'category varchar(255),' +
				             'street varchar(255),' +
				             'zip varchar(255),' +
				             'city varchar(255),' +
				             'phone varchar(255),' +
				             'email varchar(255),' +
				             'tags varchar(255),' +
				             'description text)');
}

/**
*	SQLite-DB anlegen und Verbindung zur DB herstellen
*/
AM.create_db = function() {
  var created_db = google.gears.factory.create('beta.database', '1.0');
  created_db.open('addressmanager');
	return created_db;
}

/**
*	Daten aus der Gears-SQLite-Datenbank auslesen und als Array zurueckgeben
*/
AM.get_records_from_gears = function(sql, args){
	var result = AM.execute(sql, args);
	// Array, in dem wir die ausgelesenen Datensaetze speichern und nachher zurueckgeben
	var res_array = Array();
	while (result.isValidRow()) {
	  res_array.push( {name: result.fieldByName('name'),
												category: result.fieldByName('category'),
												street: result.fieldByName('street'),
												zip: result.fieldByName('zip'),
												city: result.fieldByName('city'),
												phone: result.fieldByName('phone'),
												email: result.fieldByName('email'),
												tags: result.fieldByName('tags'),
												description: result.fieldByName('description')});
	  result.next();
	}
	result.close();
	
	return res_array;
}


/**
*	Je nachdem, in welchem Modus (Online/Offline) wir uns befinden, muss der User wieder in den anderen Modus wechseln koennen
*/
AM.init_mode_switcher = function(){
	var mode_HTML = 'Sie befinden sich momentan im <span style="color:#f00;">'+mode+'</span>-Modus &nbsp;&nbsp;&nbsp;';
	if(mode == 'online'){
		mode_HTML += '<button onclick="AM.go_offline();">In Offline-Modus wechseln</button>';
	}else{
		mode_HTML += '<button onclick="AM.go_online();">In Online-Modus wechseln</button>';
	}
	
	Element.update('online_offline_switcher', mode_HTML);
	new Effect.Highlight('online_offline_switcher');
}


/**
*	Verschiedene Helper-Funktionen fuer die Datenbank
*/
// fuehrt SQL aus - mit ErrorHandling
AM.execute = function(sql, args){
  try {
    return db.execute(sql, args);
  } catch (e) {
    alert("Folgender SQL-Befehl schlug fehl: " + sql + ". Die Fehlermeldung lautet: " + e.message);
  }
}
// loescht die Datensaetze
AM.clear_db = function(){
  AM.execute("delete from addresses");
}

AM.test = function(){
	console.log('test');
	return true;
}


/**
* Daten in JSON-String verpacken, damit dieser in unsere serverseitige Daten-Datei (data.js) geschrieben werden kann
*/
AM.data_to_string = function() {
	var ret = "AM.Data = [];\n";

	if(mode == 'online'){
		var data_container = AM.Data;
	}else{
		var data_container = AM.get_records_from_gears('select * from addresses', null);
	}

	for(var i=0; i<data_container.length; i++){
		ret += "AM.Data["+i+"] = {";
		ret += "name: '"+data_container[i].name+"',";
		ret += "category: '"+data_container[i].category+"',";
		ret += "street: '"+data_container[i].street+"',";
		ret += "zip: '"+data_container[i].zip+"',";
		ret += "city: '"+data_container[i].city+"',";
		ret += "phone: '"+data_container[i].phone+"',";
		ret += "email: '"+data_container[i].email+"',";
		ret += "tags: '"+data_container[i].tags+"',";
		ret += "description: '"+data_container[i].description+"'";
		ret += "} \n ";
	}

	return ret;
}

