File  : s_dieder.c    (in German)
Author: Jrg Michael, Hannover, Germany

Check sums based on dieder group
(program from c't, issue 04/1997)

Contents:
1. Documentation for program "dieder.c" (in German)
2. C programm "dieder.c"


/*-------------------------------------------*/


(in German:)


Dokumentation zu "dieder.c":

Prfung von beliebig langen Zahlenfeldern mittels
Diedergruppen (gesprochen Di-Eder) gem [Verhoeff].


Grundlage des Verfahrens:
Man kann beweisen (siehe [Verhoeff]), dass es neben Modulo 11 
(bis auf Isomorphie) genau ein optimales Prfziffernverfahren 
gibt, nmlich Diedergruppen.


Theorie:

Die Multiplikation erfolgt gem der Matrix "multipl":
x * y  ist identisch zu:   multipl[x][y]
Das Array "inv_dieder" dient zur Berechnung der inversen Zahl.
Es gilt also stets:    x * inv_dieder[x] = 0

Die Prfung erfolgt analog zu [Verhoeff, S.100]:
T 1 (a1) * T 2 (a2) * ... * T n (a n) = 0


Nachteil dieses Verfahrens:
Die Fehlererkennung ist weniger gut als bei Modulo 11.



Erkannte Fehler:

einfache Fehler      :  alle Fehler erkannt
Nachbarvertauschungen:  alle Fehler erkannt
phonetische Fehler   :  alle Fehler erkannt

Zwillingsvertauschung:   95,2 % erkannt
Sprungtranspositionen:   93,6 % erkannt
Sprung-Zwillingsvert.:   93,6 % erkannt

sonstige Fehler      :   90,0 % (geschtzt)



Literatur:

J. Verhoeff: Error Detecting Decimal Codes, Mathematical Centre Tracts, 
Vol. 29 (Mathematisch Centrum, Amsterdam, 1969).

R.-H. Schulz: Codierungstheorie. Eine Einfhrung, Vieweg Verlag, 
Braunschweig, Wiesbaden, 1991 (siehe Kapitel 8: Prfzeichenverfahren).

J. Michael, Mit Sicherheit, Prfziffernverfahren auf Modulo-Basis, 
c't, Heft 07/1996, S. 264-268.

J. Michael, Bltenrein, Prfziffernverfahren auf der Basis von 
Diedergruppen, c't, Heft 04/1997, S. 448-452.


/*-------------------------------------------*/


/****  Datei: dieder.c                ****/ 
/****  Berechnung von Prfziffern     ****/ 
/****     mittels Diedergruppen       ****/ 
/****  Autor: Jrg Michael, Hannover  ****/ 
/****     c't, 04/1997, S. 448-452    ****/ 

#include <stdio.h>
#include <ctype.h>
#include <string.h>

/****  Optionen  ****/ 
#define  setze_pruefziffer 
#define  loesche_trenner 
#define  trennzeichen     "/ -.:" 

/****  Fehlercodes  ****/ 
#define  ZAHL_ZU_KURZ     -1000 
#define  ZAHL_ZU_LANG     -2000 
#define  UNGUELTIGE_PARAMETER  -3000 


/****  Multiplikationstabelle der Diedergruppe  ****/
int multipl [10][10] = { { 0,1,2,3,4, 5,6,7,8,9 },
			 { 1,2,3,4,0, 6,7,8,9,5 },
			 { 2,3,4,0,1, 7,8,9,5,6 },
			 { 3,4,0,1,2, 8,9,5,6,7 },
			 { 4,0,1,2,3, 9,5,6,7,8 },

			 { 5,9,8,7,6, 0,4,3,2,1 },
			 { 6,5,9,8,7, 1,0,4,3,2 },
			 { 7,6,5,9,8, 2,1,0,4,3 },
			 { 8,7,6,5,9, 3,2,1,0,4 },
			 { 9,8,7,6,5, 4,3,2,1,0 }
		       };

/****  Inverse bzgl. Dieder-Multiplikation  ****/
int inv_multipl [10]  =  { 0,4,3,2,1, 5,6,7,8,9 };

/****  Permutationstabelle von Verhoeff  ****/
int  perm [12][10]  =  { { 2,8,6,3,4, 1,0,9,7,5 },
			 { 3,1,2,0,4, 5,6,7,8,9 },
			 { 4,9,1,2,5, 6,3,0,7,8 },
			 { 4,8,5,0,9, 7,2,6,3,1 },
			 { 1,2,6,9,4, 5,7,8,3,0 },
			 { 3,5,0,1,2, 8,9,6,7,4 },
			 { 3,8,9,4,7, 2,6,1,5,0 },
			 { 2,4,8,6,9, 0,7,1,3,5 },
			 { 1,7,9,5,0, 3,8,6,4,2 },
			 { 1,8,2,9,5, 0,4,7,6,3 },
			 { 4,3,2,6,8, 7,0,1,5,9 },
			 { 2,6,9,8,5, 4,1,3,0,7 }
		       };

/****  inverse Permutationen  ****/
int inv_perm[12][10] = { { 6,5,0,3,4, 9,2,8,1,7 },
			 { 3,1,2,0,4, 5,6,7,8,9 },
			 { 7,2,3,6,0, 4,5,8,9,1 },
			 { 3,9,6,8,0, 2,7,5,1,4 },
			 { 9,0,1,8,4, 5,2,6,7,3 },
			 { 2,3,4,0,9, 1,7,8,5,6 },
			 { 9,7,5,0,3, 8,6,4,1,2 },
			 { 5,7,0,8,1, 9,3,6,2,4 },
			 { 4,0,9,5,8, 3,7,1,6,2 },
			 { 5,0,2,9,6, 4,8,7,1,3 },
			 { 6,7,2,1,0, 8,3,5,4,9 },
			 { 8,6,0,7,5, 4,1,9,3,2 }
		       };



int hole_dieder (char zahl[], int anz_ziff, int pruef_pos)
/****  Bestimmt bzw. setzt die Prfziffer einer Zahl. ****/ 
/****  Die gesuchte Ziffer wird als Zeichen           ****/
/****  im Bereich von '0' bis '9' zurckgegeben.      ****/
{
 int i=0,k=0,n=0,
     p=-1,x=0;
 int links=0, 
     rechts=-1;
 if (anz_ziff > 0  &&  pruef_pos >= anz_ziff)
   {
    return (UNGUELTIGE_PARAMETER);
   }
 /****  "linke" und "rechte" Prfsumme bestimmen  ****/
 while ((k = (int) zahl[n]) != 0)
   {
#ifdef trennzeichen
    if (strchr (trennzeichen,k) != NULL)
      {
  #ifdef loesche_trenner
       strcpy (zahl+n, zahl+n+1);
  #else
       n++;
  #endif
       continue;
      }
#endif
    if (isdigit (k)  &&  i != pruef_pos)
      {
       k = perm [i%12] [k-'0'];
       if (rechts < 0)
	 {
	  links = multipl [links] [k];
	 }
       else
	 {
	  rechts = multipl [rechts] [k];
	 }
       n++;
       i++;
      }
    else if (pruef_pos < 0  ||  i == pruef_pos)
      {
       pruef_pos = i;
       p = n;
       rechts = 0;
       n++;
       i++;
      }
    else
      {
       break;
      }
   }

 /****  Fehlerbehandlung  ****/
 if (zahl[n] != 0  &&  zahl[n] != ' ')
   {
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/
    return (-i-1);
   }
 if (i <= 1  ||  i < anz_ziff  ||  p < 0  ||  rechts < 0)
   {
    return (ZAHL_ZU_KURZ);
    /****  oder keine Prfzeichenposition gefunden  ****/
   }
 if (anz_ziff > 0  &&  i > anz_ziff)
   {
    return (ZAHL_ZU_LANG);
   }
 /****  Prfziffer berechnen durch Umkehrung von    ****/
 /****  links * perm(pruef_pos+1) (x) * rechts = 0  ****/
 i = multipl [inv_multipl [links]] [inv_multipl [rechts]];
 x = inv_perm [pruef_pos%12] [i] + '0';
#ifdef setze_pruefziffer
   /****  Prfziffer setzen  ****/
   zahl [p] = (char) x;
#endif
 return (x);
}



int check_dieder (char zahl[], int anz_ziff)
/****  Prft eine Zahl auf Plausibilitt    ****/
/****  Ergebnis: 0 : kein Fehler erkennbar  ****/
/****           1-9: Prfsumme fehlerhaft   ****/
{
 int i=0,k=0,
     n=0,d=0;
 while ((k = (int) zahl[n]) != 0)
   {
#ifdef trennzeichen
    if (strchr (trennzeichen,k) != NULL)
      {
  #ifdef loesche_trenner
       strcpy (zahl+n, zahl+n+1);
  #else
       n++;
  #endif
       continue;
      }
#endif
    if (isdigit (k))
      {
       k = perm [i%12] [k-'0'];
       d = multipl [d] [k];
       n++;
       i++;
      }
    else
      {
       break;
      }
   }
 /****  Fehlerbehandlung  ****/
 if (zahl[n] != 0  &&  zahl[n] != ' ')
   {
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/
    return (-i-1);
   }
 if (i < anz_ziff)
   {
    return (ZAHL_ZU_KURZ);
   }
 if (anz_ziff > 0  &&  i > anz_ziff)
   {
    return (ZAHL_ZU_LANG);
   }
 return (d);
}
