// Verschiebepuzzle

// Konstanten (Variablen, deren Werte waehrend der Programmlaufzeit nicht veraendert werden,
// zur Kennzeichnung tragen diese Namen aus Grossbuchstaben):

int KL = 120;                // Kantenlaenge eines Puzzlequadrats in Pixel 
int ANZ = 5;                 // Anzahl der Puzzlequadrate hoch und quer
int BL = ANZ * KL;           // Kantenlaenge des gesamten Bilds in Pixel
int LEERX = 0;               // x-Position des leeren Felds bei sortiertem Puzzle
int LEERY = 0;               // y-Position des leeren Felds bei sortiertem Puzzle
int SLB = max(250, BL/3+20); // Breite der Seitenleiste in Pixeln
int MISCHWERT = 1000;        // Wie stark wird das Puzzle zu Anfang gemischt?

// globale Variablen (stehen allen Funktionen zur Verfuegung): 

PImage bild;         // das Bild
PImage [][] bilder;  // zweidimensionales Array der Puzzlequadrate
int lx = LEERX;      // Zeiger auf die aktuelle x-Koordinate des leeren Felds
int ly = LEERY;      // Zeiger auf die aktuelle y-Koordinate des leeren Felds
PFont ubahn;         // die verwendete Schriftart

void setup(){
  // Schrift laden, Schriftdatei muss im Unterverzeichnis 'data' vorliegen
  ubahn = loadFont("Ubahn-18.vlw");
  // ins Fenster muessen die Puzzlequadrate passen, 
  // dazu je ein Pixel Abstand dazwischen und die Seitenleiste
  size(BL + ANZ + SLB, BL + ANZ); 
  // das Bild kann auch durch ein anderes ersetzt werden, das im Unterverzeichnis 'data' liegt, 
  // allerdings muss dieses quadratisch sein mit einer Kantenlaenge von KL*BL,
  // diese Konstanten sind ggf. anzupassen
  bild = loadImage("Welt.jpg");
  bilder = new PImage [ANZ][ANZ];
  // x und y sind Zaehler fuer die Koordinaten der Puzzlequadrate  
  for (int x = 0; x < ANZ; x++){    
    for (int y = 0; y < ANZ; y++){
      bilder[x][y] = bild.get(x*KL, y*KL, KL, KL);
    }
  }
  // ein Quadrat muss anschliessend geraeumt werden
  bilder[LEERX][LEERY] = null;
  // dann wird gemischt
  verwirre();  
  // neu gezeichnet wird nur auf Anforderung (nach jedem Tastendruck)
  noLoop(); 
}

// wegen noLoop() wird nur neu gezeichnet, wenn redraw() aufgerufen wird
void draw (){
  zeichnePuzzle();
  zeichneSeitenleiste();
}

// diese Methode wird bei automatisch gedrueckter Taste aufgerufen
void keyPressed(){
  // war es eine Taste der speziellen codierten Tasten?
  if (key == CODED) {
    if (keyCode == UP){ // Cursortaste 'nach oben'
      puzzleschritt(1);
    } 
    else if (keyCode == DOWN){ // Cursortaste 'nach unten'
      puzzleschritt(2);
    }
    else if (keyCode == RIGHT){ // Cursortaste 'nach rechts'
      puzzleschritt(3);
    }
    else if (keyCode == LEFT){ // Cursortaste 'nach links'
      puzzleschritt(4);
    }
    // hier koennte man noch Funktionen fr weitere Code-Tasten einbauen
  } // Ende der Code-Tasten
  else if (key == 'v') { 
    // Druecken der Taste 'v' fuehrt zu neuer Mischung
    verwirre();
    }
  // hier koennte man noch Funktionen fuer weitere normale Tasten einbauen
  redraw(); // nach jedem Tastendruck wird neu gezeichnet
}

// zeichnet den aktuellen Status des Puzzles
void zeichnePuzzle(){
  // Hintergrund zuerst wieder schwaerzen 
  background(0);
  // dann nacheinander alle Puzzleteile zeichnen
  for (int i = 0; i < ANZ; i++){    
    for (int j = 0; j < ANZ; j++){
      // das leere Feld muss uebersprungen werden
      if (bilder[i][j] == null){
        continue; 
      }
      else {
        // zur Koordinate wird der Wert der Zaehlervariablen i und j addiert, 
        // dadurch bleibt zwischen den Puzzleteilen eine Luecke von je einem Pixel
        image(bilder[i][j], i*KL+i, j*KL+j);
      } // Ende else
    } // Ende innere for-Schleife
  } // Ende auessere for-Schleife
}

// zeichnet die Seitenleiste
void zeichneSeitenleiste(){
  // Grundierungsrechteck
  fill (50);
  rect(BL+ANZ, 0, SLB, BL+ANZ);
  // Spielanweisung schreiben
  fill (255);
  textFont(ubahn); 
  text("* Verschiebe die Puzzlesteine \n mit den Cursortasten! \n * Taste 'v' mischt die \n Puzzleteile neu. \n * So soll das Bild am Ende \n aussehen:", BL+ANZ+10, 24);
  // kleine Kopie des Bilds als Vorlage anzeigen (in 1/3 Gre),
  // Position der rechten Kante ist vom rechten Rand der Seitenleiste zehn Pixel entfernt
  image (bild, BL+ANZ+SLB-10-BL/3, 140, BL/3, BL/3);
  // im Vorlagenbild wird noch das leere Feld durch ein schwarzes Quadrat verdeckt:
  fill(0);
  rect(BL+ANZ+SLB-10-BL/3 + LEERX*KL/3, 140 + LEERY*KL/3, KL/3, KL/3);
}

// schliesst die Luecke im Puzzle mit jenem Puzzlequadrat, 
// dessen Richtung der uebergebene Parameter codiert (jeweils vom Loch aus gesehen):
// 1 = unten
// 2 = oben
// 3 = links
// 4 = rechts
void puzzleschritt(int r){
  switch (r){
  case 1:
    // ist die Verschiebung ueberhaupt moeglich? 
    if (ly < ANZ-1){
      // schiebe Puzzlequadrat unterhalb des leeren Felds auf die Position des leeren Felds
      bilder[lx][ly] = bilder[lx][ly+1];
      // korrigiere Koordinate des leeren Felds
      ly++;
      // Entferne Zeiger auf das Puzzlequadrat an der neuen Position des leeren Felds
      bilder[lx][ly] = null;
    }
    break;
  case 2:
    // ist die Verschiebung ueberhaupt moeglich? 
    if (ly > 0) {
      // schiebe Puzzlequadrat oberhalb des leeren Felds auf die Position des leeren Felds
      bilder[lx][ly] = bilder[lx][ly-1];
      // korrigiere Koordinate des leeren Felds
      ly--;
      // Entferne Zeiger auf das Puzzlequadrat an der neuen Position des leeren Felds
      bilder[lx][ly] = null;
    } 
    break;
  case 3:
    //  ist die Verschiebung ueberhaupt moeglich? 
    if (lx > 0) {
      // schiebe Puzzlequadrat links des leeren Felds auf die Position des leeren Felds
      bilder[lx][ly] = bilder[lx-1][ly];
      // korrigiere Koordinate des leeren Felds
      lx--;
      // Entferne Zeiger auf das Puzzlequadrat an der neuen Position des leeren Felds
      bilder[lx][ly] = null;
    } 
    break;
  case 4:
    // ist die Verschiebung ueberhaupt moeglich? 
    if( lx < ANZ-1) {
      // schiebe Puzzlequadrat rechts des leeren Felds auf die Position des leeren Felds
      bilder[lx][ly] = bilder[lx+1][ly];
      // korrigiere Koordinate des leeren Felds
      lx++;
      // Entferne Zeiger auf das Puzzlequadrat an der neuen Position des leeren Felds
      bilder[lx][ly] = null;
    } 
    break;
  }
}

// mischt das Puzzle
void verwirre(){
  int r = 0; // Platzhalter fuer eine zufaellige Richtung
  int z = 0; // Platzhalter fuer eine zufaellige Zahl von Schritten
  // insgesamt werden 'MISCHWERT' Verwirrzuege durchgefuehrt
  for (int i = 0; i< MISCHWERT; i++){
    // Jetzt folgt eine zufaellige Anzahl von Verschiebungen in eine Richtung, 
    // die aber kleiner ist als die Anzahl Bildquadrate laengs oder quer.
    // Die Methode random() liefert Zufallszahlen aus dem angegebenen Bereich 
    // exklusive der oberen Grenze, daher liegen die Obergrenzen eins hoeher 
    // als der maximal gewuenschte Wert!
    z = int(random(1,ANZ-1)); // zufaellige Zahl von Schritten
    r = int (random(1,5));  // zufaellige Richtung
    for (int j = 0; j<z; j++){
      puzzleschritt(r);
    } // Ende innere For-Schleife
  } // Ende aeussere For-Schleife
} // Ende verwirre
