// Zeichnet einen weissen Stern vor schwarzem Hintergrund
float winkel; // Winkel eines Strahls im Bogenmass
float laenge; // Laenge eines Strahls in Pixel
float dx;     // x-Koordinate des Linien-Endpunkts 
float dy;     // y-Koordinate des Linien-Endpunkts

size(500, 500); // Fenster oeffnen 
background(0);  // schwarz faerben

stroke(255, 150); // Linienfarbe ist weiss und nicht ganz deckend   
strokeWeight(2);  // Linienbreite zwei Pixel
smooth();         // Anti-Aliasing einschalten

// 200 Strahlen zeichnen
for (int i = 0; i < 200; i++){ 
  // zufaelliger Winkel
  winkel = random(2*PI);  
  // zufaellige Laenge zwischen 0 und halber Laenge der kleineren Fensterdimension
  laenge = random(min(width/2, height/2)); 
  // x-Koordinate des Endpunkts berechnen
  dx = cos(winkel)*laenge;
  // y-Koordinate des Endpunkts berechnen
  dy = sin(winkel)* laenge; 
  // Linie zeichnen
  line (width/2, height/2,  width/2+dx, height/2-dy);  
}
