// Stern mit PDF-Export
import processing.pdf.*;

float winkel; 
float laenge; 
float dx; 
float dy;

size(600, 600);
// PDF-Aufzeichnung beginnen
beginRecord(PDF, "Stern.pdf"); 
background(15, 15, 20);
smooth();

// Durchgaenge in sechs Farbstufen:
//               1.   2.   3.   4.   5.   6.
// Rot-Kanal    25,  50,  75, 100, 125, 150; 
// Gruen-Kanal   5,  55, 105, 155, 205, 255; 
// Blau-Kanal  100,  80,  60,  40,  20,   0;
for (int i = 0; i < 6; i++){
  stroke (i*25+25, i*50+5, 100-i*20);  
  // Linien werden zunehmend breiter
  strokeWeight(i);
  // in jeder Stufe weniger Linien zeichnen: 300, 250, 200, 150, 100, 50 
  for (int j = 0; j < 300-i*50; j++){
    winkel = random(0, 2*PI); 
    // und die Linien immer kuerzer machen: 
    // (max. 300, 250, 200, 150, 100, 50 bei Fenstergroesse 600 * 600)  
    laenge = random((min(width/2, height/2))*(6-i)/6);
    dx = cos(winkel)*laenge;
    dy = sin(winkel)* laenge;
    line (width/2, height/2,  width/2+dx, height/2-dy); 
  }
}
// PDF-Aufzeichnung beenden
endRecord();
